/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisElement;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisHittingSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InconsistentBackground;
import de.rwth.swc.coffee4j.algorithmic.conflict.MissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ReduceBasedDiagnosisHittingSetBuilder {
    private final CompleteTestModel testModel;

    public ReduceBasedDiagnosisHittingSetBuilder(CompleteTestModel testModel) {
        Preconditions.notNull(testModel);
        this.testModel = testModel;
    }

    public List<DiagnosisHittingSet> computeMinimalDiagnosisHittingSets(List<MissingInvalidTuple> missingInvalidTuples) {
        Preconditions.notNull(missingInvalidTuples);
        Preconditions.check(!missingInvalidTuples.isEmpty());
        Preconditions.check(missingInvalidTuples.stream().allMatch(mit -> this.isDiagnosisSetsOrInconsistentBackground(mit.getExplanation())));
        List<MissingInvalidTuple> extendedMissingInvalidTuples = this.extendWithDiagnosisSetsForNegatedErrorConstraints(missingInvalidTuples);
        List sets = extendedMissingInvalidTuples.stream().map(mit -> new HashSet(((DiagnosisSets)mit.getExplanation()).getDiagnosisSets().stream().map(ds -> new HashSet<DiagnosisElement>(ds.getDiagnosisElements())).collect(Collectors.toSet()))).collect(Collectors.toList());
        Set selections = sets.stream().reduce(Collections.emptySet(), this::reduceToDiagnosisHittingSets);
        return selections.stream().map(selection -> new DiagnosisHittingSet(new ArrayList<DiagnosisElement>((Collection<DiagnosisElement>)selection))).collect(Collectors.toList());
    }

    private Set<Set<DiagnosisElement>> reduceToDiagnosisHittingSets(Set<Set<DiagnosisElement>> a, Set<Set<DiagnosisElement>> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        LinkedHashSet<Set<DiagnosisElement>> sets = new LinkedHashSet<Set<DiagnosisElement>>(a.size() * b.size());
        for (Set<DiagnosisElement> aSet : a) {
            for (Set<DiagnosisElement> bSet : b) {
                LinkedHashSet<DiagnosisElement> combined = new LinkedHashSet<DiagnosisElement>(aSet.size() + bSet.size());
                combined.addAll(aSet);
                combined.addAll(bSet);
                sets.add(combined);
            }
        }
        return this.filterMinimalDiagnosisHittingSets(sets);
    }

    Set<Set<DiagnosisElement>> filterMinimalDiagnosisHittingSets(Set<Set<DiagnosisElement>> selections) {
        LinkedHashSet<Set<DiagnosisElement>> filtered = new LinkedHashSet<Set<DiagnosisElement>>();
        for (Set<DiagnosisElement> selection : selections) {
            if (!this.isMinimalDiagnosisHittingSet(selection, selections)) continue;
            filtered.add(selection);
        }
        return filtered;
    }

    boolean isMinimalDiagnosisHittingSet(Set<DiagnosisElement> candidate, Set<Set<DiagnosisElement>> diagnosisHittingSets) {
        if (candidate.size() == 1) {
            return true;
        }
        for (Set<DiagnosisElement> other : diagnosisHittingSets) {
            if (candidate == other || !this.coversAnotherDiagnosisHittingSet(candidate, other)) continue;
            return false;
        }
        return true;
    }

    private boolean coversAnotherDiagnosisHittingSet(Set<DiagnosisElement> candidate, Set<DiagnosisElement> other) {
        if (other.size() > candidate.size()) {
            return false;
        }
        for (DiagnosisElement otherElement : other) {
            if (this.containsElement(otherElement, candidate)) continue;
            return false;
        }
        return true;
    }

    private boolean containsElement(DiagnosisElement element, Set<DiagnosisElement> otherElements) {
        for (DiagnosisElement otherElement : otherElements) {
            if (!element.equals(otherElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isDiagnosisSetsOrInconsistentBackground(ConflictExplanation explanation) {
        return explanation instanceof DiagnosisSets || explanation instanceof InconsistentBackground;
    }

    private List<MissingInvalidTuple> extendWithDiagnosisSetsForNegatedErrorConstraints(List<MissingInvalidTuple> missingInvalidTuples) {
        return missingInvalidTuples.stream().map(this::extendWithDiagnosisSetsForNegatedErrorConstraint).collect(Collectors.toList());
    }

    MissingInvalidTuple extendWithDiagnosisSetsForNegatedErrorConstraint(MissingInvalidTuple mit) {
        List<DiagnosisSet> diagnosisSetList = this.copyDiagnosisSets(mit.getExplanation());
        if (!this.isMarkedAsCorrect(mit.getNegatedErrorConstraintId())) {
            diagnosisSetList.add(new DiagnosisSet(Collections.singletonList(new DiagnosisElement(mit.getNegatedErrorConstraintId(), mit.getInvolvedParameters(), mit.getMissingValues()))));
        }
        ConflictSet rootConflictSet = this.copyRootConflictSet(mit.getExplanation());
        DiagnosisSets diagnosisSets = new DiagnosisSets(rootConflictSet, diagnosisSetList);
        return new MissingInvalidTuple(mit.getNegatedErrorConstraintId(), mit.getInvolvedParameters(), mit.getMissingValues(), diagnosisSets);
    }

    private List<DiagnosisSet> copyDiagnosisSets(ConflictExplanation explanation) {
        if (explanation instanceof DiagnosisSets) {
            DiagnosisSets oldDiagnosisSets = (DiagnosisSets)explanation;
            return new ArrayList<DiagnosisSet>(oldDiagnosisSets.getDiagnosisSets());
        }
        if (explanation instanceof InconsistentBackground) {
            return new ArrayList<DiagnosisSet>();
        }
        throw new IllegalStateException();
    }

    private ConflictSet copyRootConflictSet(ConflictExplanation explanation) {
        if (explanation instanceof DiagnosisSets) {
            DiagnosisSets oldDiagnosisSets = (DiagnosisSets)explanation;
            return oldDiagnosisSets.getRootConflictSet();
        }
        if (explanation instanceof InconsistentBackground) {
            InconsistentBackground background = (InconsistentBackground)explanation;
            return new ConflictSet(background.getConflictElements());
        }
        throw new IllegalStateException();
    }

    private boolean isMarkedAsCorrect(int constraintId) {
        return this.findConstraint(constraintId).isMarkedAsCorrect();
    }

    private TupleList findConstraint(int constraintId) {
        return this.testModel.getExclusionTupleLists().stream().filter(tupleList -> tupleList.getId() == constraintId).findFirst().or(() -> this.testModel.getErrorTupleLists().stream().filter(tupleList -> tupleList.getId() == constraintId).findFirst()).orElseThrow(() -> new IllegalStateException("unknown constraint with id " + constraintId));
    }
}

