/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class TestModelExpander {
    private final int factor;
    private final CompleteTestModel testModel;

    TestModelExpander(CompleteTestModel testModel) {
        Preconditions.notNull(testModel);
        this.testModel = testModel;
        this.factor = this.computeFactor(testModel);
    }

    int getFactor() {
        return this.factor;
    }

    CompleteTestModel createExpandedTestModel() {
        List<TupleList> exclusionTuples = this.expandTupleLists(this.testModel.getExclusionTupleLists());
        List<TupleList> errorTuples = this.expandTupleLists(this.testModel.getErrorTupleLists());
        return CompleteTestModel.builder(this.testModel).exclusionTupleLists(exclusionTuples).errorTupleLists(errorTuples).build();
    }

    int computeOriginalId(TupleList tupleList) {
        return this.computeOriginalId(tupleList.getId());
    }

    int computeOriginalId(int id) {
        Preconditions.check(id > 0);
        return id / this.factor;
    }

    int computeOriginalIndexInTupleList(TupleList tupleList) {
        Preconditions.notNull(tupleList);
        return tupleList.getId() % this.factor;
    }

    private List<TupleList> expandTupleLists(List<TupleList> tupleLists) {
        return tupleLists.stream().flatMap(tupleList -> IntStream.range(0, tupleList.getTuples().size()).mapToObj(i -> new TupleList(this.computeExpandedId((TupleList)tupleList, i), tupleList.getInvolvedParameters(), Collections.singletonList(tupleList.getTuples().get(i)), tupleList.isMarkedAsCorrect()))).collect(Collectors.toList());
    }

    private int computeExpandedId(TupleList tupleList, int tupleIndex) {
        return tupleList.getId() * this.factor + tupleIndex;
    }

    private int computeFactor(CompleteTestModel testModel) {
        int tupleLists = testModel.getExclusionTupleLists().size() + testModel.getErrorTupleLists().size();
        int maxTuples = Math.max(testModel.getExclusionTupleLists().stream().mapToInt(tupleList -> tupleList.getTuples().size()).max().orElse(0), testModel.getErrorTupleLists().stream().mapToInt(tupleList -> tupleList.getTuples().size()).max().orElse(0));
        return this.computeFactor(tupleLists, maxTuples);
    }

    private int computeFactor(int tupleLists, int maxTuples) {
        int power = 1;
        if (tupleLists > 0) {
            while (tupleLists / (int)Math.pow(10.0, power) != 0) {
                ++power;
            }
        }
        if (maxTuples > 0) {
            while (maxTuples / (int)Math.pow(10.0, power) != 0) {
                ++power;
            }
        }
        return (int)Math.pow(10.0, power);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestModelExpander expander = (TestModelExpander)o;
        return this.factor == expander.factor && this.testModel.equals(expander.testModel);
    }

    public int hashCode() {
        return Objects.hash(this.factor, this.testModel);
    }

    public String toString() {
        return "TestModelExpander{factor=" + this.factor + ", testModel=" + this.testModel + "}";
    }
}

