/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict.choco;

import de.rwth.swc.coffee4j.algorithmic.conflict.choco.ChocoConstraint;
import de.rwth.swc.coffee4j.algorithmic.conflict.choco.ChocoConstraintStatus;
import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class ChocoModel {
    private final Model model;
    private final List<ChocoConstraint> enabledConstraints;
    private final List<ChocoConstraint> disabledConstraints;
    private ChocoConstraint assignmentConstraint;
    private ChocoConstraint originalNegatedConstraint;
    private ChocoConstraint oppositeNegatedConstraint;

    public ChocoModel(int[] parameterSizes, List<Constraint> constraints) {
        Preconditions.notNull(parameterSizes);
        Preconditions.notNull(constraints);
        this.checkDuplicateIds(constraints);
        this.model = new Model();
        this.model.getSettings().setCheckDeclaredConstraints(false);
        this.enabledConstraints = new ArrayList<ChocoConstraint>();
        this.disabledConstraints = new ArrayList<ChocoConstraint>();
        this.assignmentConstraint = null;
        this.originalNegatedConstraint = null;
        this.oppositeNegatedConstraint = null;
        this.createVariables(parameterSizes);
        for (Constraint constraint : constraints) {
            ChocoConstraint chocoConstraint = this.createAndPostConstraint(constraint);
            this.enabledConstraints.add(chocoConstraint);
        }
    }

    private void checkDuplicateIds(List<Constraint> constraints) {
        IntOpenHashSet uniques = new IntOpenHashSet(constraints.size());
        for (Constraint constraint : constraints) {
            Preconditions.check(uniques.add(constraint.getTupleList().getId()), "duplicate id " + constraint.getTupleList().getId());
        }
    }

    public boolean isSatisfiable() {
        return this.model.getSolver().solve();
    }

    public void reset() {
        this.model.getSolver().reset();
    }

    public int setAssignmentConstraint(int[] parameters, int[] values) {
        Preconditions.notNull(parameters);
        Preconditions.notNull(values);
        Preconditions.check(parameters.length == values.length);
        this.clearAssignmentConstraint();
        org.chocosolver.solver.constraints.Constraint[] tmp = this.model.getCstrs();
        org.chocosolver.solver.constraints.Constraint[] arithms = new org.chocosolver.solver.constraints.Constraint[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            int parameter = parameters[i];
            int value = values[i];
            Optional<Variable> candidate = this.findVariable(parameter);
            IntVar variable = (IntVar)candidate.orElseThrow(() -> new IllegalStateException("unknown variable"));
            arithms[i] = this.model.arithm(variable, "=", value);
        }
        org.chocosolver.solver.constraints.Constraint constraint = this.model.and(arithms);
        this.model.post(new org.chocosolver.solver.constraints.Constraint[]{constraint});
        org.chocosolver.solver.constraints.Constraint[] allConstraints = this.exclude(this.model.getCstrs(), tmp);
        this.assignmentConstraint = new ChocoConstraint(this.findNextUnusedId(), constraint, allConstraints, ChocoConstraintStatus.POSTED);
        this.enabledConstraints.add(this.assignmentConstraint);
        return this.assignmentConstraint.getId();
    }

    public boolean isAssignmentConstraintSet() {
        return this.assignmentConstraint != null;
    }

    public void clearAssignmentConstraint() {
        if (this.assignmentConstraint != null) {
            this.model.unpost(this.assignmentConstraint.getAllConstraints());
            if (!this.enabledConstraints.removeIf(constraint -> constraint.getId() == this.assignmentConstraint.getId())) {
                this.disabledConstraints.removeIf(constraint -> constraint.getId() == this.assignmentConstraint.getId());
            }
            this.assignmentConstraint = null;
        }
    }

    public void setNegationOfConstraint(int id) {
        this.resetNegationOfConstraint();
        this.originalNegatedConstraint = this.findConstraintById(this.enabledConstraints, id).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("no enabled constraint with id {0} found", id)));
        this.model.unpost(this.originalNegatedConstraint.getAllConstraints());
        this.enabledConstraints.remove(this.originalNegatedConstraint);
        org.chocosolver.solver.constraints.Constraint[] tmp = this.model.getCstrs();
        org.chocosolver.solver.constraints.Constraint rootConstraint = this.originalNegatedConstraint.getRootConstraint().getOpposite();
        this.model.post(new org.chocosolver.solver.constraints.Constraint[]{rootConstraint});
        org.chocosolver.solver.constraints.Constraint[] allConstraints = this.exclude(this.model.getCstrs(), tmp);
        this.oppositeNegatedConstraint = new ChocoConstraint(this.originalNegatedConstraint.getId(), rootConstraint, allConstraints, ChocoConstraintStatus.POSTED);
        this.enabledConstraints.add(this.oppositeNegatedConstraint);
    }

    public boolean hasNegatedConstraint() {
        return this.originalNegatedConstraint != null;
    }

    public void resetNegationOfConstraint() {
        if (this.originalNegatedConstraint != null) {
            this.model.unpost(this.oppositeNegatedConstraint.getAllConstraints());
            this.model.post(this.originalNegatedConstraint.getAllConstraints());
            if (!this.enabledConstraints.removeIf(constraint -> constraint.getId() == this.oppositeNegatedConstraint.getId())) {
                this.disabledConstraints.removeIf(constraint -> constraint.getId() == this.oppositeNegatedConstraint.getId());
            }
            this.enabledConstraints.add(this.originalNegatedConstraint);
            this.originalNegatedConstraint = null;
            this.oppositeNegatedConstraint = null;
        }
    }

    public void enableConstraint(int id) {
        ChocoConstraint constraint = this.findConstraintById(this.disabledConstraints, id).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("no disabled constraint with id {0} found", id)));
        this.model.post(constraint.getAllConstraints());
        constraint.setStatus(ChocoConstraintStatus.POSTED);
        this.disabledConstraints.remove(constraint);
        this.enabledConstraints.add(constraint);
    }

    public void disableConstraint(int id) {
        ChocoConstraint constraint = this.findConstraintById(this.enabledConstraints, id).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("no enabled constraint with id {0} found", id)));
        this.model.unpost(constraint.getAllConstraints());
        constraint.setStatus(ChocoConstraintStatus.UNPOSTED);
        this.enabledConstraints.remove(constraint);
        this.disabledConstraints.add(constraint);
    }

    public void enableConstraints(int ... ids) {
        for (int id : ids) {
            this.enableConstraint(id);
        }
    }

    public void disableConstraints(int ... ids) {
        for (int id : ids) {
            this.disableConstraint(id);
        }
    }

    public void enableAllConstraints() {
        for (ChocoConstraint constraint : this.disabledConstraints) {
            this.model.post(constraint.getAllConstraints());
            constraint.setStatus(ChocoConstraintStatus.POSTED);
        }
        this.enabledConstraints.addAll(this.disabledConstraints);
        this.disabledConstraints.clear();
    }

    public void disableAllConstraints() {
        for (ChocoConstraint constraint : this.enabledConstraints) {
            if (!constraint.getStatus().equals((Object)ChocoConstraintStatus.POSTED)) continue;
            this.model.unpost(constraint.getAllConstraints());
            constraint.setStatus(ChocoConstraintStatus.UNPOSTED);
        }
        this.disabledConstraints.addAll(this.enabledConstraints);
        this.enabledConstraints.clear();
    }

    public boolean allConstraintsEnabled() {
        return this.disabledConstraints.isEmpty();
    }

    private int findNextUnusedId() {
        int id = this.enabledConstraints.size() + this.disabledConstraints.size();
        while (!this.isIdUnused(id)) {
            ++id;
        }
        return id;
    }

    private boolean isIdUnused(int id) {
        return this.enabledConstraints.stream().noneMatch(constraint -> constraint.getId() == id) && this.disabledConstraints.stream().noneMatch(constraint -> constraint.getId() == id);
    }

    private Optional<ChocoConstraint> findConstraintById(List<ChocoConstraint> constraints, int id) {
        return constraints.stream().filter(constraint -> constraint.getId() == id).findFirst();
    }

    private void createVariables(int[] parameterSizes) {
        for (int i = 0; i < parameterSizes.length; ++i) {
            int parameterSize = parameterSizes[i];
            String key = String.valueOf(i);
            this.model.intVar(key, 0, parameterSize - 1);
        }
    }

    private ChocoConstraint createAndPostConstraint(Constraint constraint) {
        org.chocosolver.solver.constraints.Constraint[] tmp = this.model.getCstrs();
        org.chocosolver.solver.constraints.Constraint appliedConstraint = constraint.apply(this.model);
        this.model.post(new org.chocosolver.solver.constraints.Constraint[]{appliedConstraint});
        org.chocosolver.solver.constraints.Constraint[] allConstraints = this.exclude(this.model.getCstrs(), tmp);
        return new ChocoConstraint(constraint.getTupleList().getId(), appliedConstraint, allConstraints, ChocoConstraintStatus.POSTED);
    }

    private org.chocosolver.solver.constraints.Constraint[] exclude(org.chocosolver.solver.constraints.Constraint[] allConstraints, org.chocosolver.solver.constraints.Constraint[] excludedConstraints) {
        ArrayList<org.chocosolver.solver.constraints.Constraint> constraints = new ArrayList<org.chocosolver.solver.constraints.Constraint>();
        for (org.chocosolver.solver.constraints.Constraint constraint : allConstraints) {
            if (this.contains(constraint, excludedConstraints)) continue;
            constraints.add(constraint);
        }
        return constraints.toArray(new org.chocosolver.solver.constraints.Constraint[0]);
    }

    private boolean contains(org.chocosolver.solver.constraints.Constraint constraint, org.chocosolver.solver.constraints.Constraint[] excludedConstraints) {
        if (excludedConstraints.length == 0) {
            return false;
        }
        for (org.chocosolver.solver.constraints.Constraint excludedConstraint : excludedConstraints) {
            if (!excludedConstraint.equals(constraint)) continue;
            return true;
        }
        return false;
    }

    private Optional<Variable> findVariable(int parameter) {
        String key = String.valueOf(parameter);
        return Arrays.stream(this.model.getVars()).filter(variable -> variable.getName().equals(key)).findFirst();
    }
}

