/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict.diagnosis;

import de.rwth.swc.coffee4j.algorithmic.conflict.InternalConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.diagnosis.ConflictDiagnostician;
import de.rwth.swc.coffee4j.algorithmic.conflict.explanation.QuickConflictExplainer;
import de.rwth.swc.coffee4j.algorithmic.util.ArrayUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Queue;

interface AbstractConflictDiagnostician
extends ConflictDiagnostician {
    default public void expandNextNode(InternalConflictSet conflict, List<int[]> diagnoses, Queue<int[]> pathsToExpand) {
        int[] relaxedConstraintIds = pathsToExpand.remove();
        if (!this.isCurrentPathAlreadyCoveredByDiagnoses(relaxedConstraintIds, diagnoses)) {
            Optional<int[]> optional = AbstractConflictDiagnostician.computeMinimalConflict(conflict, relaxedConstraintIds);
            if (optional.isPresent()) {
                int[] conflictSet = optional.get();
                pathsToExpand.addAll(this.expandPaths(relaxedConstraintIds, conflictSet));
            } else {
                diagnoses.add(relaxedConstraintIds);
            }
        }
    }

    private static Optional<int[]> computeMinimalConflict(InternalConflictSet conflict, int[] currentPath) {
        Optional<InternalExplanation> optional = new QuickConflictExplainer().getMinimalConflict(conflict.getChocoModel(), conflict.getBackground(), ArrayUtil.exclude(conflict.getRelaxable(), currentPath));
        return optional.flatMap(explanation -> {
            if (explanation instanceof InternalConflictSet) {
                return Optional.of(((InternalConflictSet)explanation).getConflictSet());
            }
            return Optional.empty();
        });
    }

    default public boolean isCurrentPathAlreadyCoveredByDiagnoses(int[] currentPath, List<int[]> diagnoses) {
        Preconditions.notNull(currentPath);
        Preconditions.notNull(diagnoses);
        Preconditions.check(currentPath.length > 0);
        return diagnoses.stream().anyMatch(diagnosis -> this.isSubset((int[])diagnosis, currentPath));
    }

    default public boolean isSubset(int[] subset, int[] superset) {
        Preconditions.notNull(subset);
        Preconditions.notNull(superset);
        if (subset.length > superset.length) {
            return false;
        }
        for (int element : subset) {
            if (ArrayUtil.contains(superset, element)) continue;
            return false;
        }
        return true;
    }

    default public List<int[]> expandPaths(int[] path, int[] extensions) {
        Preconditions.notNull(path);
        Preconditions.notNull(extensions);
        Preconditions.check(extensions.length > 0);
        int[][] expansions = new int[extensions.length][];
        for (int i = 0; i < expansions.length; ++i) {
            expansions[i] = new int[path.length + 1];
            System.arraycopy(path, 0, expansions[i], 0, path.length);
            expansions[i][path.length] = extensions[i];
        }
        return Arrays.asList(expansions);
    }
}

