/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict.explanation;

import de.rwth.swc.coffee4j.algorithmic.conflict.InternalConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalInconsistentBackground;
import de.rwth.swc.coffee4j.algorithmic.conflict.choco.ChocoModel;
import de.rwth.swc.coffee4j.algorithmic.conflict.explanation.ConflictExplainer;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Optional;

public class QuickConflictExplainer
implements ConflictExplainer {
    @Override
    public Optional<InternalExplanation> getMinimalConflict(ChocoModel model, int[] background, int[] relaxable) {
        Preconditions.notNull(model);
        Preconditions.notNull(background);
        Preconditions.notNull(relaxable);
        Preconditions.check(relaxable.length > 0);
        if (this.isConsistent(model, this.union(background, relaxable))) {
            model.enableAllConstraints();
            return Optional.empty();
        }
        if (!this.isConsistent(model, background)) {
            model.enableAllConstraints();
            return Optional.of(new InternalInconsistentBackground(background, relaxable));
        }
        int[] conflictSet = this.doExplain(model, background, background, relaxable);
        model.enableAllConstraints();
        return Optional.of(new InternalConflictSet(model, background, relaxable, conflictSet));
    }

    private boolean isConsistent(ChocoModel model, int[] constraints) {
        model.disableAllConstraints();
        model.reset();
        model.enableConstraints(constraints);
        return model.isSatisfiable();
    }

    private int[] doExplain(ChocoModel problem, int[] background, int[] delta, int[] relaxable) {
        if (delta.length != 0 && !this.isConsistent(problem, background)) {
            return new int[0];
        }
        if (relaxable.length == 1) {
            return relaxable;
        }
        int k = relaxable.length / 2;
        int[] constraints1 = Arrays.copyOfRange(relaxable, 0, k);
        int[] constraints2 = Arrays.copyOfRange(relaxable, k, relaxable.length);
        int[] delta2 = this.doExplain(problem, this.union(background, constraints1), constraints1, constraints2);
        int[] delta1 = this.doExplain(problem, this.union(background, delta2), delta2, constraints1);
        return this.distinctUnion(delta1, delta2);
    }

    private int[] union(int[] a, int[] b) {
        int[] array = new int[a.length + b.length];
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    private int[] distinctUnion(int[] a, int[] b) {
        IntArraySet set = new IntArraySet();
        Arrays.stream(a).forEach(arg_0 -> ((IntSet)set).add(arg_0));
        Arrays.stream(b).forEach(arg_0 -> ((IntSet)set).add(arg_0));
        return set.toIntArray();
    }
}

