/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import org.chocosolver.solver.Model;

public class Constraint {
    private final TupleList tupleList;
    private final Function<Model, org.chocosolver.solver.constraints.Constraint> function;

    public Constraint(TupleList tupleList, Function<Model, org.chocosolver.solver.constraints.Constraint> function) {
        Preconditions.notNull(tupleList);
        Preconditions.notNull(function);
        this.tupleList = tupleList;
        this.function = function;
    }

    Constraint(Constraint other) {
        Preconditions.notNull(other);
        this.tupleList = other.tupleList;
        this.function = other.function;
    }

    public TupleList getTupleList() {
        return this.tupleList;
    }

    public org.chocosolver.solver.constraints.Constraint apply(Model model) {
        return this.function.apply(model);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constraint that = (Constraint)o;
        return this.tupleList.equals(that.tupleList) && this.function.equals(that.function);
    }

    public int hashCode() {
        return Objects.hash(this.tupleList, this.function);
    }

    public String toString() {
        return "ConstraintFunction{tupleList=" + this.tupleList + ", function=" + this.function + "}";
    }
}

