/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.ChocoUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class ConstraintConverter {
    public List<Constraint> convertAll(Collection<TupleList> tupleLists) {
        Preconditions.notNull(tupleLists);
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(tupleLists.size());
        for (TupleList forbiddenTuples : tupleLists) {
            Constraint constraint = this.convert(forbiddenTuples);
            constraints.add(constraint);
        }
        return constraints;
    }

    public Constraint convert(TupleList tupleList) {
        Preconditions.notNull(tupleList);
        Function<Model, org.chocosolver.solver.constraints.Constraint> constraint = model -> this.or((Model)model, this.createConstraints(tupleList, (Model)model)).getOpposite();
        return new Constraint(tupleList, constraint);
    }

    private org.chocosolver.solver.constraints.Constraint or(Model model, org.chocosolver.solver.constraints.Constraint[] constraints) {
        if (constraints.length == 1) {
            return constraints[0];
        }
        return model.or(constraints);
    }

    org.chocosolver.solver.constraints.Constraint and(Model model, org.chocosolver.solver.constraints.Constraint[] constraints) {
        if (constraints.length == 1) {
            return constraints[0];
        }
        return model.and(constraints);
    }

    org.chocosolver.solver.constraints.Constraint[] createConstraints(TupleList tupleList, Model model) {
        org.chocosolver.solver.constraints.Constraint[] propositions = new org.chocosolver.solver.constraints.Constraint[tupleList.getTuples().size()];
        int index = 0;
        for (int[] forbiddenTuple : tupleList.getTuples()) {
            propositions[index++] = this.createConstraints(tupleList.getInvolvedParameters(), forbiddenTuple, model);
        }
        return propositions;
    }

    org.chocosolver.solver.constraints.Constraint createConstraints(int[] involvedParameters, int[] excludedTuple, Model model) {
        org.chocosolver.solver.constraints.Constraint[] propositions = new org.chocosolver.solver.constraints.Constraint[involvedParameters.length];
        for (int i = 0; i < excludedTuple.length; ++i) {
            org.chocosolver.solver.constraints.Constraint proposition;
            Optional<org.chocosolver.solver.constraints.Constraint> optional = this.createProposition(involvedParameters[i], excludedTuple[i], model);
            propositions[i] = proposition = optional.orElseThrow(() -> new IllegalStateException("missing constraint"));
        }
        return this.and(model, propositions);
    }

    Optional<org.chocosolver.solver.constraints.Constraint> createProposition(int involvedParameter, int excludedValue, Model model) {
        Optional<Variable> candidate = ChocoUtil.findVariable(model, involvedParameter);
        if (candidate.isPresent() && candidate.get() instanceof IntVar) {
            IntVar variable = (IntVar)candidate.get();
            org.chocosolver.solver.constraints.Constraint proposition = model.arithm(variable, "=", excludedValue);
            return Optional.of(proposition);
        }
        return Optional.empty();
    }
}

