/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintConverter;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ConstraintList {
    private final Collection<TupleList> tupleLists;
    private List<Constraint> constraints;

    public ConstraintList(Collection<TupleList> tupleLists) {
        Preconditions.notNull(tupleLists);
        this.tupleLists = tupleLists;
        this.constraints = null;
    }

    public List<Constraint> getConstraints() {
        if (this.constraints == null) {
            this.constraints = new ConstraintConverter().convertAll(this.tupleLists);
        }
        return this.constraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintList that = (ConstraintList)o;
        return this.tupleLists.equals(that.tupleLists) && Objects.equals(this.constraints, that.constraints);
    }

    public int hashCode() {
        return Objects.hash(this.tupleLists, this.constraints);
    }

    public String toString() {
        return "ConstraintList{}";
    }
}

