/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintConverter;
import de.rwth.swc.coffee4j.algorithmic.constraint.ModelBasedConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.Collection;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;

class DiagnosticConstraintChecker
extends ModelBasedConstraintChecker {
    DiagnosticConstraintChecker(CompleteTestModel testModel, TupleList diagnosedTupleList, Collection<Constraint> hardConstraints, Collection<Constraint> softConstraints, Object2IntMap<IntArrayWrapper> thresholds) {
        super(DiagnosticConstraintChecker.createModel(testModel, diagnosedTupleList, hardConstraints, softConstraints, thresholds));
        Preconditions.notNull(thresholds);
        Preconditions.check(!thresholds.isEmpty());
    }

    private static Model createModel(CompleteTestModel testModel, TupleList diagnosedTupleList, Collection<Constraint> hardConstraints, Collection<Constraint> softConstraints, Object2IntMap<IntArrayWrapper> thresholds) {
        Model model = new Model();
        model.getSettings().setCheckDeclaredConstraints(false);
        DiagnosticConstraintChecker.createVariables(testModel, model);
        IntVar threshold = DiagnosticConstraintChecker.createThresholdVariable(model, thresholds);
        DiagnosticConstraintChecker.createHardConstraints(hardConstraints, model);
        DiagnosticConstraintChecker.createSoftConstraints(softConstraints, model, threshold);
        DiagnosticConstraintChecker.createThresholdConstraints(model, diagnosedTupleList, threshold, thresholds);
        return model;
    }

    private static void createVariables(CompleteTestModel testModel, Model model) {
        for (int i = 0; i < testModel.getNumberOfParameters(); ++i) {
            int parameterSize = testModel.getParameterSizes()[i];
            String key = String.valueOf(i);
            model.intVar(key, 0, parameterSize - 1);
        }
    }

    private static IntVar createThresholdVariable(Model model, Object2IntMap<IntArrayWrapper> thresholds) {
        int maxThreshold = thresholds.values().stream().mapToInt(i -> i).max().orElse(0);
        return model.intVar("threshold", 0, maxThreshold);
    }

    private static void createHardConstraints(Collection<Constraint> hardConstraints, Model model) {
        for (Constraint constraint : hardConstraints) {
            constraint.apply(model).post();
        }
    }

    private static void createSoftConstraints(Collection<Constraint> softConstraints, Model model, IntVar threshold) {
        IntVar[] reifiedVars = new IntVar[softConstraints.size()];
        int index = 0;
        for (Constraint constraint : softConstraints) {
            reifiedVars[index++] = constraint.apply(model).reify().intVar();
        }
        int[] weights = new int[softConstraints.size()];
        Arrays.fill(weights, 1);
        IntVar sum = model.intVar("sum", 0, softConstraints.size());
        model.scalar(reifiedVars, weights, "=", sum).post();
        model.arithm(sum, "+", threshold, ">=", softConstraints.size()).post();
    }

    private static void createThresholdConstraints(Model model, TupleList diagnosedTupleList, IntVar threshold, Object2IntMap<IntArrayWrapper> thresholds) {
        ConstraintConverter converter = new ConstraintConverter();
        int[] parameters = diagnosedTupleList.getInvolvedParameters();
        for (IntArrayWrapper wrapper : thresholds.keySet()) {
            DiagnosticConstraintChecker.createThresholdConstraint(model, threshold, thresholds, converter, parameters, wrapper);
        }
    }

    private static void createThresholdConstraint(Model model, IntVar threshold, Object2IntMap<IntArrayWrapper> thresholds, ConstraintConverter converter, int[] parameters, IntArrayWrapper wrapper) {
        int[] values = wrapper.getArray();
        int thresholdValue = thresholds.getInt((Object)wrapper);
        org.chocosolver.solver.constraints.Constraint condition = converter.createConstraints(parameters, values, model);
        org.chocosolver.solver.constraints.Constraint effect = model.arithm(threshold, "=", thresholdValue);
        model.ifThen(condition, effect);
    }
}

