/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.conflict.InternalMissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerUtil;
import de.rwth.swc.coffee4j.algorithmic.constraint.DiagnosticConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.DiagnosticConstraintSplitter;
import de.rwth.swc.coffee4j.algorithmic.constraint.DiagnosticConstraintThresholdComputer;
import de.rwth.swc.coffee4j.algorithmic.constraint.HardConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.InternalConflictDiagnosisManager;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class DiagnosticConstraintCheckerFactory
implements ConstraintCheckerFactory {
    private final DiagnosticConstraintSplitter splitter;
    private final DiagnosticConstraintThresholdComputer thresholdComputer;

    public DiagnosticConstraintCheckerFactory() {
        this(new DiagnosticConstraintSplitter(), new DiagnosticConstraintThresholdComputer());
    }

    public DiagnosticConstraintCheckerFactory(DiagnosticConstraintSplitter splitter, DiagnosticConstraintThresholdComputer thresholdComputer) {
        this.splitter = splitter;
        this.thresholdComputer = thresholdComputer;
    }

    @Override
    public ConstraintChecker createConstraintChecker(CompleteTestModel testModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConstraintChecker createConstraintCheckerWithNegation(CompleteTestModel testModel, TupleList toBeNegated) {
        Preconditions.notNull(testModel);
        Preconditions.check(ConstraintCheckerUtil.checkValidIdentifier(testModel, toBeNegated.getId()));
        InternalConflictDiagnosisManager diagnostician = new InternalConflictDiagnosisManager();
        List<InternalMissingInvalidTuple> missingInvalidTuples = diagnostician.diagnose(testModel, toBeNegated);
        if (missingInvalidTuples.isEmpty()) {
            return new HardConstraintCheckerFactory().createConstraintCheckerWithNegation(testModel, toBeNegated);
        }
        Pair<List<Constraint>, List<Constraint>> partitions = this.splitter.splitConstraints(testModel, toBeNegated, missingInvalidTuples);
        List hardConstraints = (List)partitions.getLeft();
        List softConstraints = (List)partitions.getRight();
        Object2IntMap<IntArrayWrapper> thresholds = this.thresholdComputer.computeThresholds(toBeNegated, missingInvalidTuples);
        return new DiagnosticConstraintChecker(testModel, toBeNegated, hardConstraints, softConstraints, thresholds);
    }
}

