/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.conflict.InternalDiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalMissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerUtil;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

class DiagnosticConstraintSplitter {
    DiagnosticConstraintSplitter() {
    }

    Pair<List<Constraint>, List<Constraint>> splitConstraints(CompleteTestModel testModel, TupleList toBeNegated, List<InternalMissingInvalidTuple> missingInvalidTuples) {
        Preconditions.notNull(testModel);
        Preconditions.notNull(toBeNegated);
        Preconditions.check(testModel.getErrorTupleLists().stream().anyMatch(tupleList -> tupleList.getId() == toBeNegated.getId()));
        Preconditions.notNull(missingInvalidTuples);
        Preconditions.check(missingInvalidTuples.stream().allMatch(mit -> mit.getExplanation() instanceof InternalDiagnosisSets));
        ArrayList<Constraint> hardConstraints = new ArrayList<Constraint>();
        ArrayList<Constraint> softConstraints = new ArrayList<Constraint>();
        hardConstraints.add(ConstraintCheckerUtil.negateConstraint(ConstraintCheckerUtil.findErrorConstraintToBeNegated(testModel, toBeNegated)));
        ArrayList<Constraint> remainingConstraints = new ArrayList<Constraint>();
        remainingConstraints.addAll(testModel.getExclusionConstraints());
        remainingConstraints.addAll(ConstraintCheckerUtil.filterErrorConstraintToBeNegated(testModel, toBeNegated));
        this.partitionRemainingConstraints(missingInvalidTuples, remainingConstraints, hardConstraints, softConstraints);
        return Pair.of(hardConstraints, softConstraints);
    }

    private void partitionRemainingConstraints(List<InternalMissingInvalidTuple> missingInvalidTuples, List<Constraint> remainingConstraints, List<Constraint> hardConstraints, List<Constraint> softConstraints) {
        for (Constraint constraint : remainingConstraints) {
            if (this.requiresRelaxation(missingInvalidTuples, constraint)) {
                softConstraints.add(constraint);
                continue;
            }
            hardConstraints.add(constraint);
        }
    }

    private boolean requiresRelaxation(List<InternalMissingInvalidTuple> missingInvalidTuples, Constraint constraint) {
        for (InternalMissingInvalidTuple tuple : missingInvalidTuples) {
            InternalDiagnosisSets sets = (InternalDiagnosisSets)tuple.getExplanation();
            for (int[] diagnosisSet : sets.getDiagnosisSets()) {
                boolean match = Arrays.stream(diagnosisSet).anyMatch(id -> id == constraint.getTupleList().getId());
                if (!match) continue;
                return true;
            }
        }
        return false;
    }
}

