/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.conflict.InternalDiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalMissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.algorithmic.util.TupleUtil;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

class DiagnosticConstraintThresholdComputer {
    DiagnosticConstraintThresholdComputer() {
    }

    Object2IntMap<IntArrayWrapper> computeThresholds(TupleList toBeNegated, List<InternalMissingInvalidTuple> missingInvalidTuples) {
        Preconditions.notNull(toBeNegated);
        Preconditions.notNull(missingInvalidTuples);
        Preconditions.check(missingInvalidTuples.stream().allMatch(mit -> mit.getExplanation() instanceof InternalDiagnosisSets));
        Object2IntArrayMap thresholds = new Object2IntArrayMap();
        for (int[] tuple : toBeNegated.getTuples()) {
            Optional<InternalMissingInvalidTuple> optional = this.findMissingInvalidTuple(toBeNegated, tuple, missingInvalidTuples);
            int threshold = optional.map(this::computeThreshold).orElse(0);
            thresholds.put((Object)IntArrayWrapper.wrap(tuple), threshold);
        }
        return thresholds;
    }

    private Optional<InternalMissingInvalidTuple> findMissingInvalidTuple(TupleList toBeNegated, int[] tuple, List<InternalMissingInvalidTuple> missingInvalidTuples) {
        return missingInvalidTuples.stream().filter(missingInvalidTuple -> missingInvalidTuple.getNegatedErrorConstraintId() == toBeNegated.getId()).filter(missingInvalidTuple -> TupleUtil.tuplesAreEqual(missingInvalidTuple.getInvolvedParameters(), missingInvalidTuple.getMissingValues(), toBeNegated.getInvolvedParameters(), tuple)).findFirst();
    }

    private int computeThreshold(InternalMissingInvalidTuple missingInvalidTuple) {
        InternalDiagnosisSets sets = (InternalDiagnosisSets)missingInvalidTuple.getExplanation();
        return Arrays.stream(sets.getDiagnosisSets()).mapToInt(diagnosisSet -> ((int[])diagnosisSet).length).max().orElseThrow(() -> new IllegalStateException("no diagnosis sets"));
    }
}

