/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintConverter;
import de.rwth.swc.coffee4j.algorithmic.constraint.ModelBasedConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.chocosolver.solver.Model;

public class DynamicHardConstraintChecker
extends ModelBasedConstraintChecker {
    private final IntSet involvedParameters = new IntArraySet();
    private final ConstraintConverter converter = new ConstraintConverter();

    public DynamicHardConstraintChecker(CompleteTestModel inputParameterModel, List<Constraint> exclusionConstraints, List<Constraint> errorConstraints) {
        super(DynamicHardConstraintChecker.createModel(inputParameterModel, exclusionConstraints, errorConstraints));
        inputParameterModel.getErrorTupleLists().stream().map(TupleList::getInvolvedParameters).flatMapToInt(Arrays::stream).forEach(arg_0 -> ((IntSet)this.involvedParameters).add(arg_0));
        inputParameterModel.getExclusionTupleLists().stream().map(TupleList::getInvolvedParameters).flatMapToInt(Arrays::stream).forEach(arg_0 -> ((IntSet)this.involvedParameters).add(arg_0));
    }

    private static Model createModel(CompleteTestModel inputParameterModel, Collection<Constraint> exclusionConstraints, Collection<Constraint> errorConstraints) {
        Model model = new Model();
        model.getSettings().setCheckDeclaredConstraints(false);
        DynamicHardConstraintChecker.createVariables(inputParameterModel, model);
        DynamicHardConstraintChecker.createConstraints(exclusionConstraints, errorConstraints, model);
        return model;
    }

    private static void createVariables(CompleteTestModel inputParameterModel, Model model) {
        for (int i = 0; i < inputParameterModel.getNumberOfParameters(); ++i) {
            int parameterSize = inputParameterModel.getParameterSizes()[i];
            String key = String.valueOf(i);
            model.intVar(key, 0, parameterSize - 1);
        }
    }

    private static void createConstraints(Collection<Constraint> exclusionConstraints, Collection<Constraint> errorConstraints, Model model) {
        for (Constraint constraint : exclusionConstraints) {
            constraint.apply(model).post();
        }
        for (Constraint errorConstraint : errorConstraints) {
            errorConstraint.apply(model).post();
        }
    }

    @Override
    public void addConstraint(int[] forbiddenCombination) {
        int numberOfSetParameters = CombinationUtil.numberOfSetParameters(forbiddenCombination);
        if (numberOfSetParameters == 0) {
            this.model.post(new org.chocosolver.solver.constraints.Constraint[]{this.model.falseConstraint()});
        } else {
            int[] parameters = new int[numberOfSetParameters];
            int[] values = new int[numberOfSetParameters];
            int current = 0;
            for (int parameter = 0; parameter < forbiddenCombination.length; ++parameter) {
                if (forbiddenCombination[parameter] == -1) continue;
                this.involvedParameters.add(parameter);
                parameters[current] = parameter;
                values[current] = forbiddenCombination[parameter];
                ++current;
            }
            this.model.post(new org.chocosolver.solver.constraints.Constraint[]{this.converter.createConstraints(parameters, values, this.model).getOpposite()});
        }
    }

    public IntSet getInvolvedParameters() {
        return this.involvedParameters;
    }
}

