/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerUtil;
import de.rwth.swc.coffee4j.algorithmic.constraint.MinimalForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class ExistentialMinimalForbiddenTuplesCheckerFactory
implements ConstraintCheckerFactory {
    @Override
    public ConstraintChecker createConstraintChecker(CompleteTestModel testModel) {
        throw new UnsupportedOperationException("can only be used by IpogNeg");
    }

    @Override
    public ConstraintChecker createConstraintCheckerWithNegation(CompleteTestModel testModel, TupleList toBeNegated) {
        Preconditions.check(ConstraintCheckerUtil.checkValidIdentifier(testModel, toBeNegated.getId()));
        TupleList negatedErrorConstraint = this.buildExistentialNegatedErrorConstraint(testModel, toBeNegated);
        ArrayList<TupleList> errorConstraints = new ArrayList<TupleList>(testModel.getErrorTupleLists());
        errorConstraints.remove(toBeNegated);
        errorConstraints.add(negatedErrorConstraint);
        CompleteTestModel newTestModel = CompleteTestModel.builder(testModel).errorTupleLists(errorConstraints).build();
        return new MinimalForbiddenTuplesChecker(newTestModel);
    }

    private TupleList buildExistentialNegatedErrorConstraint(CompleteTestModel testModel, TupleList toBeNegated) {
        Int2IntOpenHashMap relevantParameterSizes = new Int2IntOpenHashMap();
        for (int parameter : toBeNegated.getInvolvedParameters()) {
            relevantParameterSizes.put(parameter, testModel.getParameterSize(parameter));
        }
        int[] existentialTuple = toBeNegated.getTuples().get(0);
        int[] expandedExistentialTuple = this.expandExistentialTuple(testModel, toBeNegated, existentialTuple);
        Collection complementTuples = Combinator.computeCartesianProduct((Int2IntMap)relevantParameterSizes, testModel.getNumberOfParameters()).stream().filter(tuple -> !Arrays.equals(tuple, expandedExistentialTuple)).collect(Collectors.toList());
        ArrayList<int[]> forbiddenValueCombinations = new ArrayList<int[]>(complementTuples.size());
        for (int[] combination : complementTuples) {
            int[] forbiddenCombination = new int[toBeNegated.getInvolvedParameters().length];
            int param = 0;
            for (int parameter : toBeNegated.getInvolvedParameters()) {
                forbiddenCombination[param] = combination[parameter];
                ++param;
            }
            forbiddenValueCombinations.add(forbiddenCombination);
        }
        return new TupleList(toBeNegated.getId(), toBeNegated.getInvolvedParameters(), forbiddenValueCombinations);
    }

    private int[] expandExistentialTuple(CompleteTestModel testModel, TupleList toBeNegated, int[] existentialTuple) {
        int[] expandedExistentialTuple = new int[testModel.getNumberOfParameters()];
        Arrays.fill(expandedExistentialTuple, -1);
        int param = 0;
        for (int parameter : toBeNegated.getInvolvedParameters()) {
            expandedExistentialTuple[parameter] = existentialTuple[param];
            ++param;
        }
        return expandedExistentialTuple;
    }
}

