/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class ForbiddenTuplesChecker
implements ConstraintChecker {
    private final CompleteTestModel model;
    private Set<IntList> initialForbiddenTuples;
    Set<IntList> minimalForbiddenTuples;
    final int[] parameterSizes;
    final int numberOfParameters;
    final Multimap<IntList, IntList> parameterValuesToTupleMap = MultimapBuilder.hashKeys().hashSetValues().build();
    final Multimap<Integer, IntList> parameterToUsedValuesMap;

    ForbiddenTuplesChecker(CompleteTestModel model) {
        this.model = model;
        this.parameterSizes = model.getParameterSizes();
        this.numberOfParameters = model.getNumberOfParameters();
        IntArrayList parameters = new IntArrayList(this.parameterSizes);
        parameters.sort(null);
        this.parameterToUsedValuesMap = MultimapBuilder.hashKeys((int)this.numberOfParameters).hashSetValues(parameters.getInt(this.numberOfParameters - 1)).build();
        this.generateInitialForbiddenTupleSet();
        this.generateMinimalForbiddenTupleSet();
    }

    ForbiddenTuplesChecker(ForbiddenTuplesChecker checker) {
        this.model = checker.model;
        this.initialForbiddenTuples = new HashSet<IntList>(checker.initialForbiddenTuples);
        this.minimalForbiddenTuples = new HashSet<IntList>(checker.minimalForbiddenTuples);
        this.parameterSizes = Arrays.copyOf(checker.parameterSizes, checker.parameterSizes.length);
        this.numberOfParameters = checker.numberOfParameters;
        IntArrayList parameters = new IntArrayList(this.parameterSizes);
        parameters.sort(null);
        this.parameterToUsedValuesMap = MultimapBuilder.hashKeys((int)this.numberOfParameters).hashSetValues(parameters.getInt(this.numberOfParameters - 1)).build();
    }

    protected abstract void generateMinimalForbiddenTupleSet();

    protected abstract void generateNecessaryForbiddenTupleSet(int[] var1);

    private void generateInitialForbiddenTupleSet() {
        int[] emptyCombination = CombinationUtil.emptyCombination(this.numberOfParameters);
        HashSet<TupleList> forbiddenTupleLists = new HashSet<TupleList>(this.model.getExclusionTupleLists());
        forbiddenTupleLists.addAll(this.model.getErrorTupleLists());
        for (TupleList list : forbiddenTupleLists) {
            int[] involvedParameters = list.getInvolvedParameters();
            for (int[] values : list.getTuples()) {
                IntArrayList combination = new IntArrayList(emptyCombination);
                HashSet<IntArrayList> parameterValuePairs = new HashSet<IntArrayList>();
                for (int index = 0; index < involvedParameters.length; ++index) {
                    IntArrayList pair = new IntArrayList(new int[]{involvedParameters[index], values[index]});
                    this.parameterToUsedValuesMap.put((Object)involvedParameters[index], (Object)pair);
                    parameterValuePairs.add(pair);
                    combination.set(involvedParameters[index], values[index]);
                }
                parameterValuePairs.forEach(arg_0 -> this.lambda$generateInitialForbiddenTupleSet$0((IntList)combination, arg_0));
            }
        }
        this.initialForbiddenTuples = new HashSet<IntList>(this.parameterValuesToTupleMap.values());
        this.minimalForbiddenTuples = new HashSet<IntList>(this.initialForbiddenTuples);
    }

    void updateMultiMaps(Set<IntList> newTuples) {
        for (IntList tuple : newTuples) {
            for (int param = 0; param < this.numberOfParameters; ++param) {
                if (tuple.getInt(param) == -1) continue;
                IntArrayList key = new IntArrayList(new int[]{param, tuple.getInt(param)});
                this.parameterValuesToTupleMap.put((Object)key, (Object)tuple);
                this.parameterToUsedValuesMap.put((Object)param, (Object)key);
            }
        }
        this.minimalForbiddenTuples = new HashSet<IntList>(this.parameterValuesToTupleMap.values());
    }

    public Set<IntList> getMinimalForbiddenTuples() {
        return this.minimalForbiddenTuples;
    }

    public Set<IntList> getInitialForbiddenTuples() {
        return this.initialForbiddenTuples;
    }

    @Override
    public boolean isValid(int[] combination) {
        this.generateNecessaryForbiddenTupleSet(combination);
        for (IntList forbiddenTuple : this.minimalForbiddenTuples) {
            if (!CombinationUtil.contains(combination, forbiddenTuple.toIntArray())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isExtensionValid(int[] combination, int ... parameterValues) {
        Preconditions.check(parameterValues.length % 2 == 0);
        int[] newCombination = CombinationUtil.emptyCombination(this.numberOfParameters);
        System.arraycopy(combination, 0, newCombination, 0, combination.length);
        for (int i = 0; i < parameterValues.length - 1; i += 2) {
            newCombination[parameterValues[i]] = parameterValues[i + 1];
        }
        return this.isValid(newCombination);
    }

    @Override
    public boolean isDualValid(int[] parameters, int[] values) {
        Preconditions.check(parameters.length == values.length);
        int[] newCombination = CombinationUtil.emptyCombination(this.numberOfParameters);
        for (int i = 0; i < parameters.length; ++i) {
            newCombination[parameters[i]] = values[i];
        }
        return this.isValid(newCombination);
    }

    private /* synthetic */ void lambda$generateInitialForbiddenTupleSet$0(IntList combination, IntList pair) {
        this.parameterValuesToTupleMap.put((Object)pair, (Object)combination);
    }
}

