/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ModelBasedConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import java.util.Collection;
import java.util.List;
import org.chocosolver.solver.Model;

class HardConstraintChecker
extends ModelBasedConstraintChecker {
    HardConstraintChecker(CompleteTestModel testModel, List<Constraint> exclusionConstraints, List<Constraint> errorConstraints) {
        super(HardConstraintChecker.createModel(testModel, exclusionConstraints, errorConstraints));
    }

    private static Model createModel(CompleteTestModel testModel, List<Constraint> exclusionConstraints, List<Constraint> errorConstraints) {
        Model model = new Model();
        model.getSettings().setCheckDeclaredConstraints(false);
        HardConstraintChecker.createVariables(testModel, model);
        HardConstraintChecker.createConstraints(exclusionConstraints, errorConstraints, model);
        return model;
    }

    private static void createVariables(CompleteTestModel testModel, Model model) {
        for (int i = 0; i < testModel.getNumberOfParameters(); ++i) {
            int parameterSize = testModel.getParameterSizes()[i];
            String key = String.valueOf(i);
            model.intVar(key, 0, parameterSize - 1);
        }
    }

    private static void createConstraints(Collection<Constraint> exclusionConstraints, Collection<Constraint> errorConstraints, Model model) {
        for (Constraint constraint : exclusionConstraints) {
            constraint.apply(model).post();
        }
        for (Constraint errorConstraint : errorConstraints) {
            errorConstraint.apply(model).post();
        }
    }
}

