/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.conflict.InternalConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalDiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalMissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.choco.ChocoModel;
import de.rwth.swc.coffee4j.algorithmic.conflict.diagnosis.ConflictDiagnostician;
import de.rwth.swc.coffee4j.algorithmic.conflict.diagnosis.ExhaustiveConflictDiagnostician;
import de.rwth.swc.coffee4j.algorithmic.conflict.explanation.ConflictExplainer;
import de.rwth.swc.coffee4j.algorithmic.conflict.explanation.QuickConflictExplainer;
import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class InternalConflictDiagnosisManager {
    private final ConflictExplainer explainer = new QuickConflictExplainer();
    private final ConflictDiagnostician diagnostician = new ExhaustiveConflictDiagnostician();

    InternalConflictDiagnosisManager() {
    }

    List<InternalMissingInvalidTuple> diagnose(CompleteTestModel testModel, TupleList toBeNegated) {
        Preconditions.notNull(testModel);
        Preconditions.notNull(toBeNegated);
        Preconditions.check(testModel.getErrorTupleLists().stream().anyMatch(tupleList -> tupleList.getId() == toBeNegated.getId()));
        ArrayList<InternalMissingInvalidTuple> missingInvalidTuples = new ArrayList<InternalMissingInvalidTuple>();
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraints.addAll(testModel.getExclusionConstraints());
        constraints.addAll(testModel.getErrorConstraints());
        ChocoModel chocoModel = new ChocoModel(testModel.getParameterSizes(), constraints);
        chocoModel.setNegationOfConstraint(toBeNegated.getId());
        IntArraySet background = new IntArraySet();
        background.add(toBeNegated.getId());
        IntArraySet relaxable = new IntArraySet();
        relaxable.addAll((Collection)constraints.stream().filter(constraint -> constraint.getTupleList().getId() != toBeNegated.getId()).map(constraint -> constraint.getTupleList().getId()).collect(Collectors.toList()));
        for (int[] tuple : toBeNegated.getTuples()) {
            chocoModel.reset();
            int assignmentId = chocoModel.setAssignmentConstraint(toBeNegated.getInvolvedParameters(), tuple);
            background.add(assignmentId);
            Optional<InternalDiagnosisSets> optional = this.runConflictDiagnosis(chocoModel, (IntSet)background, (IntSet)relaxable);
            optional.ifPresent(explanation -> missingInvalidTuples.add(new InternalMissingInvalidTuple(toBeNegated.getId(), toBeNegated.getInvolvedParameters(), tuple, (InternalExplanation)explanation)));
            chocoModel.clearAssignmentConstraint();
            background.remove(assignmentId);
        }
        return missingInvalidTuples;
    }

    private Optional<InternalDiagnosisSets> runConflictDiagnosis(ChocoModel chocoModel, IntSet background, IntSet relaxable) {
        return chocoModel.isSatisfiable() ? Optional.empty() : this.explainer.getMinimalConflict(chocoModel, background.toIntArray(), relaxable.toIntArray()).filter(explanation -> explanation instanceof InternalConflictSet).map(explanation -> (InternalConflictSet)explanation).map(explanation -> new InternalDiagnosisSets((InternalConflictSet)explanation, this.diagnostician.getMinimalDiagnoses((InternalConflictSet)explanation)));
    }
}

