/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import com.google.common.collect.Multimap;
import de.rwth.swc.coffee4j.algorithmic.constraint.ForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.MinimalForbiddenTuplesCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.util.TupleBuilderUtil;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MinimalForbiddenTuplesChecker
extends ForbiddenTuplesChecker {
    public MinimalForbiddenTuplesChecker(CompleteTestModel model) {
        super(model);
    }

    public MinimalForbiddenTuplesChecker(ForbiddenTuplesChecker checker) {
        super(checker);
    }

    public static MinimalForbiddenTuplesCheckerFactory minimalForbiddenTuplesChecker() {
        return new MinimalForbiddenTuplesCheckerFactory();
    }

    @Override
    protected void generateMinimalForbiddenTupleSet() {
        Set<IntList> newDerivedTuples;
        boolean newTuplesDerived;
        do {
            newDerivedTuples = this.deriveNewTuples();
        } while (newTuplesDerived = !this.simplifyTupleSet().containsAll(newDerivedTuples));
    }

    private Set<IntList> deriveNewTuples() {
        Set<IntList> newTuples = new HashSet<IntList>();
        for (int currentParam = 0; currentParam < this.numberOfParameters; ++currentParam) {
            newTuples.addAll(this.deriveNewTuplesUsingParameter(currentParam));
        }
        if (!(newTuples = this.removeAlreadyIdentifiedTuples(newTuples)).isEmpty()) {
            this.updateMultiMaps(newTuples);
        }
        return newTuples;
    }

    private Collection<IntList> deriveNewTuplesUsingParameter(int param) {
        Collection usedValuesForParameter = this.parameterToUsedValuesMap.get((Object)param);
        if (usedValuesForParameter.size() < this.parameterSizes[param]) {
            return Collections.emptySet();
        }
        Set forbiddenTuplesForParameter = usedValuesForParameter.stream().map(arg_0 -> ((Multimap)this.parameterValuesToTupleMap).get(arg_0)).collect(Collectors.toSet());
        HashSet<Collection<IntList>> forbiddenSet = new HashSet<Collection<IntList>>();
        for (Collection set : forbiddenTuplesForParameter) {
            HashSet<IntArrayList> newSet = new HashSet<IntArrayList>();
            for (IntList tuple : set) {
                IntArrayList newTuple = new IntArrayList(tuple);
                newTuple.set(param, -1);
                newSet.add(newTuple);
            }
            forbiddenSet.add(newSet);
        }
        return TupleBuilderUtil.buildCartesianProduct(forbiddenSet, this.numberOfParameters);
    }

    private Set<IntList> removeAlreadyIdentifiedTuples(Set<IntList> newTuples) {
        Collection oldTuples = this.parameterValuesToTupleMap.values();
        return newTuples.stream().filter(tuple -> !oldTuples.contains(tuple)).collect(Collectors.toSet());
    }

    private Set<IntList> simplifyTupleSet() {
        HashSet<IntList> removedTuples = new HashSet<IntList>();
        for (IntList combination : this.minimalForbiddenTuples) {
            List<Object> subCombinations = new ArrayList(this.minimalForbiddenTuples);
            subCombinations.remove(combination);
            if ((subCombinations = subCombinations.stream().filter(subCombination -> CombinationUtil.contains(combination.toIntArray(), subCombination.toIntArray())).collect(Collectors.toList())).isEmpty()) continue;
            removedTuples.add(combination);
            for (int param = 0; param < this.numberOfParameters; ++param) {
                int value = combination.getInt(param);
                if (value == -1) continue;
                IntArrayList key = new IntArrayList(new int[]{param, value});
                this.parameterValuesToTupleMap.remove((Object)key, (Object)combination);
                if (this.parameterValuesToTupleMap.containsKey((Object)key)) continue;
                this.parameterToUsedValuesMap.remove((Object)param, (Object)key);
            }
        }
        this.minimalForbiddenTuples = new HashSet(this.parameterValuesToTupleMap.values());
        return removedTuples;
    }

    @Override
    protected void generateNecessaryForbiddenTupleSet(int[] combination) {
    }

    @Override
    public void addConstraint(int[] forbiddenTuple) {
        IntArrayList key;
        int param;
        if (Arrays.equals(forbiddenTuple, CombinationUtil.emptyCombination(forbiddenTuple.length))) {
            for (param = 0; param < this.numberOfParameters; ++param) {
                key = new IntArrayList(new int[]{param, forbiddenTuple[param]});
                this.parameterValuesToTupleMap.put((Object)key, (Object)new IntArrayList(forbiddenTuple));
                this.parameterToUsedValuesMap.put((Object)param, (Object)key);
            }
        }
        for (param = 0; param < this.numberOfParameters; ++param) {
            if (forbiddenTuple[param] == -1) continue;
            key = new IntArrayList(new int[]{param, forbiddenTuple[param]});
            this.parameterValuesToTupleMap.put((Object)key, (Object)new IntArrayList(forbiddenTuple));
            this.parameterToUsedValuesMap.put((Object)param, (Object)key);
        }
        this.generateMinimalForbiddenTupleSet();
    }
}

