/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerUtil;
import de.rwth.swc.coffee4j.algorithmic.constraint.MinimalForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class MinimalForbiddenTuplesCheckerFactory
implements ConstraintCheckerFactory {
    @Override
    public ConstraintChecker createConstraintChecker(CompleteTestModel testModel) {
        return new MinimalForbiddenTuplesChecker(testModel);
    }

    @Override
    public ConstraintChecker createConstraintCheckerWithNegation(CompleteTestModel testModel, TupleList toBeNegated) {
        Preconditions.check(ConstraintCheckerUtil.checkValidIdentifier(testModel, toBeNegated.getId()));
        TupleList negatedErrorConstraint = this.buildNegatedErrorConstraint(testModel, toBeNegated);
        ArrayList<TupleList> errorConstraints = new ArrayList<TupleList>(testModel.getErrorTupleLists());
        errorConstraints.remove(toBeNegated);
        errorConstraints.add(negatedErrorConstraint);
        CompleteTestModel newTestModel = CompleteTestModel.builder(testModel).errorTupleLists(errorConstraints).build();
        return new MinimalForbiddenTuplesChecker(newTestModel);
    }

    private TupleList buildNegatedErrorConstraint(CompleteTestModel testModel, TupleList toBeNegated) {
        Int2IntOpenHashMap relevantParameterSizes = new Int2IntOpenHashMap();
        for (int parameter : toBeNegated.getInvolvedParameters()) {
            relevantParameterSizes.put(parameter, testModel.getParameterSize(parameter));
        }
        MinimalForbiddenTuplesChecker tempChecker = new MinimalForbiddenTuplesChecker(CompleteTestModel.builder(testModel).exclusionTupleLists(List.of()).errorTupleLists(List.of(toBeNegated)).build());
        Collection complementTuples = Combinator.computeCartesianProduct((Int2IntMap)relevantParameterSizes, testModel.getNumberOfParameters()).stream().filter(tempChecker::isValid).collect(Collectors.toList());
        ArrayList<int[]> forbiddenValueCombinations = new ArrayList<int[]>(complementTuples.size());
        for (int[] combination : complementTuples) {
            int[] forbiddenCombination = new int[toBeNegated.getInvolvedParameters().length];
            int param = 0;
            for (int parameter : toBeNegated.getInvolvedParameters()) {
                forbiddenCombination[param] = combination[parameter];
                ++param;
            }
            forbiddenValueCombinations.add(forbiddenCombination);
        }
        return new TupleList(toBeNegated.getId(), toBeNegated.getInvolvedParameters(), forbiddenValueCombinations);
    }
}

