/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.util.ChocoUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.variables.IntVar;

public abstract class ModelBasedConstraintChecker
implements ConstraintChecker {
    protected final Model model;

    ModelBasedConstraintChecker(Model model) {
        this.model = Preconditions.notNull(model);
    }

    @Override
    public boolean isValid(int[] combination) {
        List<Constraint> constraintsList = this.createAssignmentConstraints(combination, this.model);
        return this.runChocoSolver(this.model, constraintsList);
    }

    private List<Constraint> createAssignmentConstraints(int[] combination, Model model) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (int i = 0; i < combination.length; ++i) {
            if (combination[i] == -1) continue;
            this.addAssignmentConstraint(i, combination[i], model, constraints);
        }
        return constraints;
    }

    private void addAssignmentConstraint(int parameter, int value, Model model, List<Constraint> constraints) {
        if (value == -1) {
            return;
        }
        IntVar variable = ChocoUtil.findVariable(model, parameter).filter(v -> v instanceof IntVar).map(v -> (IntVar)v).orElseThrow(() -> new IllegalStateException("unknown variable"));
        Constraint constraint = model.arithm(variable, "=", value);
        constraints.add(constraint);
    }

    @Override
    public boolean isExtensionValid(int[] combination, int ... parameterValues) {
        Preconditions.check(parameterValues.length % 2 == 0);
        List<Constraint> constraintsList = this.createAssignmentConstraints(combination, this.model);
        for (int i = 0; i < parameterValues.length; i += 2) {
            this.addAssignmentConstraint(parameterValues[i], parameterValues[i + 1], this.model, constraintsList);
        }
        return this.runChocoSolver(this.model, constraintsList);
    }

    @Override
    public boolean isDualValid(int[] parameters, int[] values) {
        Preconditions.check(parameters.length == values.length);
        ArrayList<Constraint> constraintsList = new ArrayList<Constraint>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            this.addAssignmentConstraint(parameters[i], values[i], this.model, constraintsList);
        }
        return this.runChocoSolver(this.model, constraintsList);
    }

    @Override
    public void addConstraint(int[] forbiddenTuple) {
    }

    private boolean runChocoSolver(Model model, List<Constraint> temporaryConstraints) {
        Constraint[] constraints = temporaryConstraints.toArray(new Constraint[0]);
        model.post(constraints);
        boolean result = model.getSolver().solve();
        model.unpost(constraints);
        model.getSolver().reset();
        return result;
    }
}

