/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ModelBasedConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;

class SoftConstraintChecker
extends ModelBasedConstraintChecker {
    SoftConstraintChecker(CompleteTestModel testModel, Collection<Constraint> hardConstraints, Collection<Constraint> softConstraints, int threshold) {
        super(SoftConstraintChecker.createModel(testModel, hardConstraints, softConstraints, threshold));
        Preconditions.check(0 <= threshold && threshold <= softConstraints.size());
    }

    private static Model createModel(CompleteTestModel testModel, Collection<Constraint> hardConstraints, Collection<Constraint> softConstraints, int threshold) {
        Model model = new Model();
        model.getSettings().setCheckDeclaredConstraints(false);
        SoftConstraintChecker.createVariables(testModel, model);
        SoftConstraintChecker.createHardConstraints(hardConstraints, model);
        SoftConstraintChecker.createSoftConstraints(softConstraints, threshold, model);
        return model;
    }

    private static void createVariables(CompleteTestModel testModel, Model model) {
        for (int i = 0; i < testModel.getNumberOfParameters(); ++i) {
            int parameterSize = testModel.getParameterSizes()[i];
            String key = String.valueOf(i);
            model.intVar(key, 0, parameterSize - 1);
        }
    }

    private static void createHardConstraints(Collection<Constraint> hardConstraints, Model model) {
        for (Constraint constraint : hardConstraints) {
            constraint.apply(model).post();
        }
    }

    private static void createSoftConstraints(Collection<Constraint> softConstraints, int threshold, Model model) {
        IntVar[] reifiedVars = new IntVar[softConstraints.size()];
        int index = 0;
        for (Constraint constraint : softConstraints) {
            reifiedVars[index++] = constraint.apply(model).reify().intVar();
        }
        int[] weights = new int[softConstraints.size()];
        Arrays.fill(weights, 1);
        IntVar sum = model.intVar("sum", 0, softConstraints.size());
        model.arithm(sum, ">=", softConstraints.size() - threshold).post();
        model.scalar(reifiedVars, weights, "=", sum).post();
    }
}

