/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.constraint;

import de.rwth.swc.coffee4j.algorithmic.conflict.InternalDiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalMissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerUtil;
import de.rwth.swc.coffee4j.algorithmic.constraint.HardConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.InternalConflictDiagnosisManager;
import de.rwth.swc.coffee4j.algorithmic.constraint.SoftConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SoftConstraintCheckerFactory
implements ConstraintCheckerFactory {
    @Override
    public ConstraintChecker createConstraintChecker(CompleteTestModel testModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConstraintChecker createConstraintCheckerWithNegation(CompleteTestModel testModel, TupleList toBeNegated) {
        Preconditions.notNull(testModel);
        Preconditions.check(ConstraintCheckerUtil.checkValidIdentifier(testModel, toBeNegated.getId()));
        int threshold = this.computeThreshold(testModel, toBeNegated);
        if (threshold == 0) {
            return new HardConstraintCheckerFactory().createConstraintCheckerWithNegation(testModel, toBeNegated);
        }
        ArrayList<Constraint> hardConstraints = new ArrayList<Constraint>();
        hardConstraints.add(ConstraintCheckerUtil.negateConstraint(ConstraintCheckerUtil.findErrorConstraintToBeNegated(testModel, toBeNegated)));
        List<Constraint> softConstraints = ConstraintCheckerUtil.filterErrorConstraintToBeNegated(testModel, toBeNegated);
        softConstraints.addAll(testModel.getExclusionConstraints());
        return new SoftConstraintChecker(testModel, hardConstraints, softConstraints, threshold);
    }

    private int computeThreshold(CompleteTestModel testModel, TupleList toBeNegated) {
        InternalConflictDiagnosisManager diagnostician = new InternalConflictDiagnosisManager();
        List<InternalMissingInvalidTuple> missingInvalidTuples = diagnostician.diagnose(testModel, toBeNegated);
        return missingInvalidTuples.isEmpty() ? 0 : missingInvalidTuples.stream().flatMapToInt(tuple -> Arrays.stream(((InternalDiagnosisSets)tuple.getExplanation()).getDiagnosisSets()).mapToInt(diagnosisSet -> ((int[])diagnosisSet).length)).max().orElseThrow(() -> new IllegalStateException("cannot compute threshold"));
    }
}

