/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CoverageMap {
    private final Set<int[]> uncoveredCombinations;
    private final ConstraintChecker checker;
    private final int numberOfParameters;
    private final Set<IntList> passingTestInputs;
    private final IntSet parameters = new IntArraySet();

    public CoverageMap(int[] parameterSizes, int strength, ConstraintChecker checker) {
        Preconditions.notNull(parameterSizes);
        Preconditions.check(strength > 0 && strength <= parameterSizes.length);
        this.checker = Preconditions.notNull(checker);
        this.uncoveredCombinations = Combinator.computeCombinations(parameterSizes, strength).stream().filter(checker::isValid).collect(Collectors.toSet());
        this.numberOfParameters = parameterSizes.length;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            this.parameters.add(i);
        }
        this.passingTestInputs = new HashSet<IntList>();
    }

    public CoverageMap(CoverageMap coverageMap, ConstraintChecker checker) {
        this.uncoveredCombinations = new HashSet<int[]>(coverageMap.uncoveredCombinations);
        this.numberOfParameters = coverageMap.numberOfParameters;
        this.passingTestInputs = new HashSet<IntList>(coverageMap.passingTestInputs);
        this.checker = checker;
    }

    public Set<IntList> getPassingTestInputs() {
        return this.passingTestInputs;
    }

    public boolean allCombinationsCovered() {
        return this.uncoveredCombinations.isEmpty();
    }

    public void updateCoverage(int[] testInput) {
        this.passingTestInputs.add((IntList)new IntArrayList(testInput));
        this.uncoveredCombinations.removeIf(combination -> CombinationUtil.contains(testInput, combination));
    }

    public void updateCoverage() {
        this.uncoveredCombinations.removeIf(combination -> !this.checker.isValid((int[])combination));
    }

    public long getNumberOfCoveredCombinationsByTestInput(int[] testInput) {
        long numberOfCombinationsCoveredByTestInput = this.uncoveredCombinations.stream().filter(combination -> CombinationUtil.contains(testInput, combination)).count();
        long numberOfCombinationsContainingPartialTestInput = this.uncoveredCombinations.stream().filter(combination -> this.numberOfSetValues(testInput) < this.numberOfSetValues((int[])combination) && CombinationUtil.contains(combination, testInput)).count();
        return numberOfCombinationsContainingPartialTestInput + numberOfCombinationsCoveredByTestInput;
    }

    private int numberOfSetValues(int[] testInput) {
        return (int)Arrays.stream(testInput).filter(value -> value != -1).count();
    }

    public ParameterValuePair getParameterValuePairCoveringMostCombinations(Set<ParameterValuePair> forbiddenPairs) {
        int optimalParameter = -1;
        int optimalValue = -1;
        long maximumNumberOfCoveredCombinations = 0L;
        IntArrayList randomOrderParameters = new IntArrayList((IntCollection)this.parameters);
        Collections.shuffle(randomOrderParameters);
        IntListIterator intListIterator = randomOrderParameters.iterator();
        while (intListIterator.hasNext()) {
            int parameter = (Integer)intListIterator.next();
            Int2IntArrayMap parameterValueCoverageCount = new Int2IntArrayMap();
            for (int[] combination : this.uncoveredCombinations) {
                if (combination[parameter] == -1 || forbiddenPairs.contains(new ParameterValuePair(parameter, combination[parameter]))) continue;
                parameterValueCoverageCount.put(combination[parameter], parameterValueCoverageCount.getOrDefault(combination[parameter], 0) + 1);
            }
            Optional<Int2IntMap.Entry> optimalValueForParameter = parameterValueCoverageCount.int2IntEntrySet().stream().max(Comparator.comparing(Int2IntMap.Entry::getIntValue));
            if (!optimalValueForParameter.isPresent() || (long)optimalValueForParameter.get().getIntValue() <= maximumNumberOfCoveredCombinations) continue;
            optimalParameter = parameter;
            optimalValue = optimalValueForParameter.get().getIntKey();
            maximumNumberOfCoveredCombinations = optimalValueForParameter.get().getIntValue();
        }
        return new ParameterValuePair(optimalParameter, optimalValue);
    }
}

