/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.feedback;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.interleaving.feedback.FeedbackCheckingConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.feedback.FeedbackCheckingStrategy;
import de.rwth.swc.coffee4j.algorithmic.interleaving.feedback.FeedbackCheckingStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.util.OptimalValue;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

public class DefaultFeedbackCheckingStrategy
implements FeedbackCheckingStrategy {
    private final CoverageMap coverageMap;
    private final ConstraintChecker checker;
    private final CompleteTestModel testModel;
    private int[] candidate;
    private final int numberOfParameters;
    private final int numberOfFeedbackChecks;
    private int[] processedTestInput;
    private final IntList parameters;
    private List<int[]> dissimilarTestInputSet;

    private DefaultFeedbackCheckingStrategy(FeedbackCheckingConfiguration configuration) {
        this.coverageMap = configuration.getCoverageMap();
        this.checker = configuration.getConstraintChecker();
        this.testModel = configuration.getTestModel();
        this.numberOfFeedbackChecks = configuration.getNumberOfFeedbackChecks();
        this.numberOfParameters = this.testModel.getNumberOfParameters();
        this.parameters = new IntArrayList(this.numberOfParameters);
        IntStream.range(0, this.numberOfParameters).forEach(arg_0 -> ((IntList)this.parameters).add(arg_0));
    }

    public static FeedbackCheckingStrategyFactory defaultCheckingStrategy() {
        return DefaultFeedbackCheckingStrategy::new;
    }

    @Override
    public Optional<int[]> startFeedbackChecking(int[] candidate, int[] processedTestInput) {
        this.candidate = candidate;
        this.processedTestInput = processedTestInput;
        this.dissimilarTestInputSet = this.generateDissimilarTestInputSet();
        return this.selectDissimilarTestInput();
    }

    public String toString() {
        return "DefaultFeedbackCheckingStrategy";
    }

    private List<int[]> generateDissimilarTestInputSet() {
        ArrayList<int[]> alreadyGeneratedTestInputs = new ArrayList<int[]>();
        alreadyGeneratedTestInputs.add(this.processedTestInput);
        for (int numberOfTestInputs = 0; numberOfTestInputs < this.numberOfFeedbackChecks; ++numberOfTestInputs) {
            ArrayList candidateTestInputs = new ArrayList();
            for (int iteration = 0; iteration < 50; ++iteration) {
                Optional<int[]> possibleTestInput = this.generateDissimilarTestInput(alreadyGeneratedTestInputs);
                possibleTestInput.ifPresent(candidateTestInputs::add);
            }
            if (candidateTestInputs.size() == 1) {
                alreadyGeneratedTestInputs.add((int[])candidateTestInputs.get(0));
                continue;
            }
            if (candidateTestInputs.isEmpty()) continue;
            alreadyGeneratedTestInputs.add(Collections.max(candidateTestInputs, Comparator.comparing(this.coverageMap::getNumberOfCoveredCombinationsByTestInput)));
        }
        return alreadyGeneratedTestInputs;
    }

    @Override
    public Optional<int[]> generateNextTestInputForChecking(int[] testInput, TestResult testResult) {
        if (testResult.isSuccessful()) {
            return Optional.empty();
        }
        return this.selectDissimilarTestInput();
    }

    private Optional<int[]> selectDissimilarTestInput() {
        if (!this.dissimilarTestInputSet.isEmpty()) {
            return Optional.of(this.dissimilarTestInputSet.remove(0));
        }
        return Optional.empty();
    }

    private Optional<int[]> generateDissimilarTestInput(List<int[]> dissimilarFrom) {
        int[] nextTestInput = Arrays.copyOf(this.candidate, this.numberOfParameters);
        Collections.shuffle(this.parameters);
        IntListIterator intListIterator = this.parameters.iterator();
        while (intListIterator.hasNext()) {
            int parameter = (Integer)intListIterator.next();
            if (nextTestInput[parameter] != -1) continue;
            Optional<ParameterValuePair> optimalValue = OptimalValue.mostDissimilarForParameter(parameter, this.testModel.getParameterSize(parameter), nextTestInput, dissimilarFrom, this.checker);
            if (optimalValue.isPresent()) {
                nextTestInput[parameter] = optimalValue.get().getValue();
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(nextTestInput);
    }
}

