/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.feedback;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;

public class FeedbackCheckingConfiguration {
    private final CompleteTestModel testModel;
    private final ConstraintChecker constraintChecker;
    private final CoverageMap coverageMap;
    private final int numberOfFeedbackChecks;

    private FeedbackCheckingConfiguration(Builder builder) {
        Preconditions.check(builder.numberOfFeedbackChecks > 0);
        this.testModel = Preconditions.notNull(builder.testModel);
        this.constraintChecker = Preconditions.notNull(builder.constraintChecker);
        this.coverageMap = Preconditions.notNull(builder.coverageMap);
        this.numberOfFeedbackChecks = builder.numberOfFeedbackChecks;
    }

    public static Builder configuration() {
        return new Builder();
    }

    public CompleteTestModel getTestModel() {
        return this.testModel;
    }

    public ConstraintChecker getConstraintChecker() {
        return this.constraintChecker;
    }

    public CoverageMap getCoverageMap() {
        return this.coverageMap;
    }

    public int getNumberOfFeedbackChecks() {
        return this.numberOfFeedbackChecks;
    }

    public static class Builder {
        private static final int DEFAULT_NUMBER_OF_FEEDBACK_CHECKS = 20;
        private CompleteTestModel testModel;
        private ConstraintChecker constraintChecker;
        private CoverageMap coverageMap;
        private int numberOfFeedbackChecks = 20;

        public Builder testModel(CompleteTestModel testModel) {
            this.testModel = testModel;
            return this;
        }

        public Builder constraintChecker(ConstraintChecker constraintChecker) {
            this.constraintChecker = constraintChecker;
            return this;
        }

        public Builder coverageMap(CoverageMap coverageMap) {
            this.coverageMap = coverageMap;
            return this;
        }

        public Builder numberOfFeedbackChecks(int numberOfFeedbackChecks) {
            this.numberOfFeedbackChecks = numberOfFeedbackChecks;
            return this;
        }

        public FeedbackCheckingConfiguration build() {
            return new FeedbackCheckingConfiguration(this);
        }
    }
}

