/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.generator.aetg;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.ForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.MinimalForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.interleaving.generator.TestInputGenerationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.generator.TestInputGenerationStrategy;
import de.rwth.swc.coffee4j.algorithmic.interleaving.generator.TestInputGenerationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.util.OptimalValue;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;

public class AetgStrategy
implements TestInputGenerationStrategy {
    private final CoverageMap coverageMap;
    private final ConstraintChecker checker;
    private final CompleteTestModel testModel;
    private static final int NUMBER_OF_DIFFERENT_TEST_INPUTS = 25;
    private final int numberOfParameters;
    private final int numberOfParameterValuePairs;
    private final IntList parameters;
    private final Random seed = ThreadLocalRandom.current();

    private AetgStrategy(TestInputGenerationConfiguration configuration) {
        this.coverageMap = configuration.getCoverageMap();
        this.checker = configuration.getConstraintChecker();
        this.testModel = configuration.getTestModel();
        this.numberOfParameters = this.testModel.getNumberOfParameters();
        this.numberOfParameterValuePairs = Arrays.stream(this.testModel.getParameterSizes()).reduce(Integer::sum).orElse(0);
        this.parameters = new IntArrayList(this.numberOfParameters);
        IntStream.range(0, this.numberOfParameters).forEach(arg_0 -> ((IntList)this.parameters).add(arg_0));
    }

    public static TestInputGenerationStrategyFactory aetgStrategy() {
        return AetgStrategy::new;
    }

    @Override
    public Optional<int[]> generateNextTestInput() {
        if (this.coverageMap.allCombinationsCovered()) {
            return Optional.empty();
        }
        ArrayList candidateTestInputs = new ArrayList(25);
        MinimalForbiddenTuplesChecker tempChecker = new MinimalForbiddenTuplesChecker((ForbiddenTuplesChecker)this.checker);
        CoverageMap tempCoverageMap = new CoverageMap(this.coverageMap, tempChecker);
        ExecutorService candidateBuilderService = Executors.newCachedThreadPool();
        for (int iteration = 0; iteration < 25; ++iteration) {
            Runnable task = () -> {
                Optional<int[]> possibleTestInput = this.generatePossibleTestInput();
                possibleTestInput.ifPresent(candidateTestInputs::add);
            };
            candidateBuilderService.execute(task);
        }
        candidateBuilderService.shutdown();
        try {
            candidateBuilderService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Coffee4JException(e, "Creating candidate test inputs took too long!", new Object[0]);
        }
        if (candidateTestInputs.isEmpty()) {
            return Optional.empty();
        }
        if (candidateTestInputs.size() == 1) {
            return Optional.of((int[])candidateTestInputs.get(0));
        }
        return Optional.of(Collections.max(candidateTestInputs, Comparator.comparing(tempCoverageMap::getNumberOfCoveredCombinationsByTestInput)));
    }

    private Optional<int[]> generatePossibleTestInput() {
        IntArrayList tempParameters = new IntArrayList(this.parameters);
        int[] testInput = CombinationUtil.emptyCombination(this.numberOfParameters);
        boolean isSatisfying = false;
        HashSet<ParameterValuePair> forbiddenPairs = new HashSet<ParameterValuePair>();
        ParameterValuePair firstParameterValuePair = null;
        while (!isSatisfying) {
            if (forbiddenPairs.size() >= this.numberOfParameterValuePairs) {
                return Optional.empty();
            }
            firstParameterValuePair = this.getFirstParameterAndValue(forbiddenPairs);
            isSatisfying = this.checker.isExtensionValid(testInput, firstParameterValuePair.getParameter(), firstParameterValuePair.getValue());
            if (isSatisfying) continue;
            forbiddenPairs.add(firstParameterValuePair);
        }
        testInput[firstParameterValuePair.getParameter()] = firstParameterValuePair.getValue();
        Collections.shuffle(tempParameters, this.seed);
        OptimalValue optimalValueFinder = new OptimalValue();
        IntListIterator intListIterator = tempParameters.iterator();
        while (intListIterator.hasNext()) {
            int parameter = (Integer)intListIterator.next();
            if (testInput[parameter] != -1) continue;
            Optional<ParameterValuePair> optimalValue = optimalValueFinder.forParameter(parameter, this.testModel.getParameterSize(parameter), (IntSet)new IntArraySet(), testInput, this.coverageMap, this.checker);
            if (!optimalValue.isPresent()) {
                return Optional.empty();
            }
            testInput[optimalValue.get().getParameter()] = optimalValue.get().getValue();
        }
        return Optional.of(testInput);
    }

    private ParameterValuePair getFirstParameterAndValue(Set<ParameterValuePair> forbiddenPairs) {
        return this.coverageMap.getParameterValuePairCoveringMostCombinations(forbiddenPairs);
    }

    public String toString() {
        return "AetgStrategy";
    }
}

