/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.identification.ofot;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.CombinationType;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.util.OptimalValue;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OfotStrategy
implements IdentificationStrategy {
    private final CoverageMap coverageMap;
    private final ConstraintChecker checker;
    private final CompleteTestModel testModel;
    private IntList currentlyProcessedTestInput;
    private CombinationType errorType;
    private List<IntList> mutatedTestInputsToTest;
    private Map<int[], TestResult> executedMutatedTestInputs;
    private List<IntSet> alreadyUsedValuesInMutations;
    private final int numberOfParameters;
    private Map<IntList, CombinationType> possiblyInducingCombinations = new HashMap<IntList, CombinationType>();

    private OfotStrategy(IdentificationConfiguration configuration) {
        this.coverageMap = configuration.getCoverageMap();
        this.checker = configuration.getConstraintChecker();
        this.testModel = configuration.getTestModel();
        this.numberOfParameters = this.testModel.getNumberOfParameters();
    }

    public static IdentificationStrategyFactory ofotStrategy() {
        return OfotStrategy::new;
    }

    @Override
    public Optional<int[]> startIdentification(int[] testInput, TestResult result) {
        Optional<Throwable> optCause = result.getResultValue();
        if (!optCause.isPresent()) {
            throw new Coffee4JException("Cause of Failure must be present!");
        }
        this.currentlyProcessedTestInput = new IntArrayList(testInput);
        this.alreadyUsedValuesInMutations = new ArrayList<IntSet>();
        this.executedMutatedTestInputs = new HashMap<int[], TestResult>();
        this.errorType = optCause.get() instanceof ErrorConstraintException ? CombinationType.EXCEPTION_INDUCING : CombinationType.FAILURE_INDUCING;
        for (int parameter = 0; parameter < this.numberOfParameters; ++parameter) {
            this.alreadyUsedValuesInMutations.add((IntSet)new IntArraySet());
            this.alreadyUsedValuesInMutations.get(parameter).add(this.currentlyProcessedTestInput.getInt(parameter));
        }
        return this.restartIdentification();
    }

    private List<IntList> mutateFailingTestInput(IntList testInput) {
        ArrayList<IntList> mutatedTestInputs = new ArrayList<IntList>(this.numberOfParameters);
        for (int parameter = 0; parameter < this.numberOfParameters; ++parameter) {
            Optional<IntList> possibleTestInput = this.computeMutatedTestInputForParameter(parameter, testInput, this.alreadyUsedValuesInMutations.get(parameter));
            if (!possibleTestInput.isPresent()) continue;
            mutatedTestInputs.add(possibleTestInput.get());
            this.alreadyUsedValuesInMutations.get(parameter).add(possibleTestInput.get().getInt(parameter));
        }
        return mutatedTestInputs;
    }

    private Optional<IntList> computeMutatedTestInputForParameter(int parameter, IntList testInput, IntSet forbidden) {
        IntArrayList nextTestInput = new IntArrayList(testInput);
        OptimalValue optimalValueFinder = new OptimalValue();
        Optional<ParameterValuePair> optimalValue = optimalValueFinder.forParameter(parameter, this.testModel.getParameterSize(parameter), (IntSet)new IntArraySet((IntCollection)forbidden), nextTestInput.toIntArray(), this.coverageMap, this.checker);
        if (!optimalValue.isPresent()) {
            return Optional.empty();
        }
        nextTestInput.set(optimalValue.get().getParameter(), optimalValue.get().getValue());
        return Optional.of(nextTestInput);
    }

    @Override
    public Optional<int[]> restartIdentification() {
        this.possiblyInducingCombinations = new HashMap<IntList, CombinationType>();
        this.mutatedTestInputsToTest = this.mutateFailingTestInput(this.currentlyProcessedTestInput);
        if (this.mutatedTestInputsToTest.isEmpty()) {
            this.identifyPossiblyInducingCombinations();
            return Optional.empty();
        }
        return Optional.of(this.mutatedTestInputsToTest.remove(0).toIntArray());
    }

    @Override
    public Optional<int[]> generateNextTestInputForIdentification(int[] testInput, TestResult testResult) {
        this.executedMutatedTestInputs.put(testInput, testResult);
        if (this.mutatedTestInputsToTest.isEmpty()) {
            this.identifyPossiblyInducingCombinations();
            return Optional.empty();
        }
        return Optional.of(this.mutatedTestInputsToTest.remove(0).toIntArray());
    }

    private void identifyPossiblyInducingCombinations() {
        int[] possiblyInducingCombination = CombinationUtil.emptyCombination(this.numberOfParameters);
        for (Map.Entry<int[], TestResult> test : this.executedMutatedTestInputs.entrySet()) {
            Optional<Throwable> optionalThrowable;
            if (!test.getValue().isSuccessful() && (!(optionalThrowable = test.getValue().getResultValue()).isPresent() || !this.differentError(optionalThrowable.get()))) continue;
            this.extractChangedParameter(possiblyInducingCombination, test.getKey());
        }
        this.possiblyInducingCombinations.put((IntList)new IntArrayList(possiblyInducingCombination), this.errorType);
    }

    private void extractChangedParameter(int[] possiblyInducingCombination, int[] testInput) {
        for (int parameter = 0; parameter < this.numberOfParameters; ++parameter) {
            if (testInput[parameter] == this.currentlyProcessedTestInput.getInt(parameter)) continue;
            possiblyInducingCombination[parameter] = this.currentlyProcessedTestInput.getInt(parameter);
        }
    }

    private boolean differentError(Throwable throwable) {
        if (this.errorType == CombinationType.FAILURE_INDUCING) {
            return throwable instanceof ErrorConstraintException;
        }
        return !(throwable instanceof ErrorConstraintException);
    }

    public String toString() {
        return "OfotStrategy";
    }

    @Override
    public Map<IntList, CombinationType> getIdentifiedCombinations() {
        return this.possiblyInducingCombinations;
    }
}

