/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt;

import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt.TupleNode;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TreeBuilder {
    private TreeBuilder() {
    }

    public static TupleNode createTree(int size, int numberOfParameters, List<Set<TupleNode>> nodes) {
        if (size > numberOfParameters) {
            size = numberOfParameters;
        }
        BitSet rootNode = new BitSet(numberOfParameters);
        rootNode.flip(0, numberOfParameters);
        TupleNode trt = new TupleNode(rootNode);
        HashSet<BitSet> leaves = new HashSet<BitSet>(numberOfParameters);
        for (int index = 0; index < numberOfParameters; ++index) {
            BitSet leaf = new BitSet(numberOfParameters);
            leaf.set(index);
            leaves.add(leaf);
        }
        nodes.add(leaves.stream().map(TupleNode::new).collect(Collectors.toSet()));
        for (int currentSize = 0; currentSize < size - 1 && currentSize < numberOfParameters - 2; ++currentSize) {
            HashSet<TupleNode> nextSet = new HashSet<TupleNode>();
            for (TupleNode child : nodes.get(currentSize)) {
                for (int index = child.getTuple().length(); index < numberOfParameters; ++index) {
                    BitSet parent = (BitSet)child.getTuple().clone();
                    parent.set(index);
                    nextSet.add(new TupleNode(parent));
                }
            }
            nodes.add(nextSet);
        }
        if (numberOfParameters > 1) {
            nodes.add(Collections.singleton(trt));
            Collections.reverse(nodes);
        }
        for (int i = 0; i < nodes.size() - 1; ++i) {
            int finalI = i;
            nodes.get(i).forEach(node -> node.setPossibleChildNodes((Set)nodes.get(finalI + 1)));
            nodes.get(finalI + 1).forEach(node -> node.setPossibleParentNodes((Set)nodes.get(finalI)));
        }
        return trt;
    }
}

