/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt;

import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt.TupleStatus;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.BitSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class TupleNode {
    private final BitSet tuple;
    private TupleStatus status;
    private Set<TupleNode> childNodes;
    private Set<TupleNode> possibleChildNodes;
    private Set<TupleNode> parentNodes;
    private Set<TupleNode> possibleParentNodes;

    TupleNode(BitSet tuple) {
        this.tuple = tuple;
        this.status = TupleStatus.UNKNOWN;
        this.childNodes = null;
        this.possibleChildNodes = null;
        this.parentNodes = null;
        this.possibleParentNodes = null;
    }

    TupleNode(TupleNode node) {
        this.tuple = (BitSet)node.tuple.clone();
        this.status = node.status;
        this.childNodes = node.childNodes;
        this.possibleChildNodes = node.possibleChildNodes;
        this.parentNodes = node.parentNodes;
        this.possibleParentNodes = node.possibleParentNodes;
    }

    BitSet getTuple() {
        return this.tuple;
    }

    boolean hasChildren() {
        return this.possibleChildNodes != null;
    }

    boolean hasParents() {
        return this.possibleParentNodes != null;
    }

    void setPossibleChildNodes(Set<TupleNode> possibleChildNodes) {
        this.possibleChildNodes = possibleChildNodes;
    }

    void setPossibleParentNodes(Set<TupleNode> possibleParentNodes) {
        this.possibleParentNodes = possibleParentNodes;
    }

    Set<TupleNode> getChildren() {
        if (this.possibleChildNodes != null) {
            if (this.childNodes == null) {
                this.childNodes = this.possibleChildNodes.stream().filter(this::isParentOf).collect(Collectors.toSet());
            }
            return this.childNodes;
        }
        return Collections.emptySet();
    }

    Set<TupleNode> getParents() {
        if (this.possibleParentNodes != null) {
            if (this.parentNodes == null) {
                this.parentNodes = this.possibleParentNodes.stream().filter(this::isChildOf).collect(Collectors.toSet());
            }
            return this.parentNodes;
        }
        return Collections.emptySet();
    }

    void setHealthy() {
        this.status = TupleStatus.HEALTHY;
    }

    void setFaulty() {
        this.status = TupleStatus.FAULTY;
    }

    void setAsExceptionInducingCombination() {
        this.status = TupleStatus.EXCEPTIONAL_COMBINATION;
    }

    void setAsUnknown() {
        this.status = TupleStatus.UNKNOWN;
    }

    boolean isUnknown() {
        return this.status == TupleStatus.UNKNOWN;
    }

    boolean isHealthy() {
        return this.status == TupleStatus.HEALTHY;
    }

    boolean isFaulty() {
        return this.status == TupleStatus.FAULTY;
    }

    boolean isExceptionInducingCombination() {
        return this.status == TupleStatus.EXCEPTIONAL_COMBINATION;
    }

    TupleStatus getStatus() {
        return this.status;
    }

    boolean isDirectParentOf(TupleNode node) {
        if (this.tuple.length() >= node.tuple.length()) {
            if (this.tuple.cardinality() == node.tuple.cardinality() + 1) {
                for (int index = 0; index < this.tuple.length(); ++index) {
                    if (!node.tuple.get(index) || this.tuple.get(index)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    boolean isParentOf(TupleNode node) {
        if (this.tuple.length() >= node.tuple.length()) {
            for (int index = 0; index < this.tuple.length(); ++index) {
                if (!node.tuple.get(index) || this.tuple.get(index)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean isChildOf(TupleNode node) {
        return node.isParentOf(this);
    }

    boolean hasUnknownTuples() throws InterruptedException {
        if (this.status == TupleStatus.UNKNOWN) {
            return true;
        }
        if (this.possibleChildNodes == null) {
            return false;
        }
        ExecutorService es = Executors.newCachedThreadPool();
        AtomicBoolean hasUnknownChildren = new AtomicBoolean(false);
        for (TupleNode child : this.getChildren()) {
            Runnable task = () -> {
                if (child.hasUnknownChildrenThread()) {
                    hasUnknownChildren.set(true);
                }
            };
            es.execute(task);
        }
        es.shutdown();
        es.awaitTermination(2L, TimeUnit.MINUTES);
        return false;
    }

    private boolean hasUnknownChildrenThread() {
        if (this.status == TupleStatus.UNKNOWN) {
            return true;
        }
        if (this.possibleChildNodes == null) {
            return false;
        }
        for (TupleNode child : this.getChildren()) {
            if (!child.hasUnknownChildrenThread()) continue;
            return true;
        }
        return false;
    }

    public boolean isMinimalInducingTuple() {
        if (this.status != TupleStatus.EXCEPTIONAL_COMBINATION && this.status != TupleStatus.FAULTY) {
            return false;
        }
        if (this.possibleChildNodes == null) {
            return true;
        }
        for (TupleNode child : this.getChildren()) {
            if (!child.isFaulty() && !child.isExceptionInducingCombination() && !child.isUnknown()) continue;
            return false;
        }
        return true;
    }

    public int getSize() {
        return this.tuple.cardinality();
    }

    public int[] getCombination(int[] failingTestInput) {
        Preconditions.check(failingTestInput.length >= this.tuple.length());
        int[] combination = new int[failingTestInput.length];
        for (int index = 0; index < failingTestInput.length; ++index) {
            combination[index] = this.tuple.get(index) ? failingTestInput[index] : -1;
        }
        return combination;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tuple, this.status});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleNode tupleNode = (TupleNode)o;
        return this.tuple.equals(tupleNode.tuple) && this.status == tupleNode.status;
    }
}

