/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.CombinationType;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt.TreeBuilder;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt.TupleNode;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.trt.TupleStatus;
import de.rwth.swc.coffee4j.algorithmic.interleaving.util.OptimalValue;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class TupleRelationshipStrategy
implements IdentificationStrategy {
    final CoverageMap coverageMap;
    final ConstraintChecker checker;
    final CompleteTestModel testModel;
    TupleNode root = null;
    private final Set<IntList> passingTestInputs = new HashSet<IntList>();
    protected int[] currentlyProcessedTestInput;
    private TestResult resultOfCurrentlyProcessedTestInput;
    private TupleNode templateTRT;
    private final List<Set<TupleNode>> templateNodes = new ArrayList<Set<TupleNode>>();
    private final ExecutorService trtBuildExecutorService = Executors.newCachedThreadPool();
    TupleNode currentlySelectedNode;
    List<TupleNode> currentlySelectedLongestPath;
    int head = 0;
    int middle = 0;
    int tail = 0;
    final int numberOfParameters;
    final IntList parameters;
    private List<TupleNode> tempPath;
    private static final int MAXIMUM_NUMBER_OF_ITERATIONS = 50;
    private int iteration = 1;
    private final List<int[]> alreadyExecutedTests = new ArrayList<int[]>();
    final Map<IntList, CombinationType> possiblyInducingCombinations = new HashMap<IntList, CombinationType>();
    List<Throwable> exceptionsTriggeredByCurrentlySelectedNode;
    private boolean maximumPathFound;
    private static final int MAXIMUM_NUMBER_OF_PARAMETERS_FOR_FULL_TREE = 14;
    private boolean firstRound = true;

    TupleRelationshipStrategy(IdentificationConfiguration configuration) {
        this.coverageMap = configuration.getCoverageMap();
        this.checker = configuration.getConstraintChecker();
        this.testModel = configuration.getTestModel();
        this.numberOfParameters = this.testModel.getNumberOfParameters();
        this.parameters = new IntArrayList(this.numberOfParameters);
        IntStream.range(0, this.numberOfParameters).forEach(arg_0 -> ((IntList)this.parameters).add(arg_0));
        this.buildTemplateTree();
    }

    private void buildTemplateTree() {
        int size = this.numberOfParameters;
        if (this.numberOfParameters > 14) {
            for (int i = 1; i <= 14; ++i) {
                if (CombinatoricsUtils.binomialCoefficient((int)this.numberOfParameters, (int)i) <= 5000L) continue;
                size = i - 1;
                break;
            }
        }
        int finalSize = size;
        Runnable task = () -> {
            this.templateTRT = TreeBuilder.createTree(finalSize, this.numberOfParameters, this.templateNodes);
        };
        this.trtBuildExecutorService.execute(task);
        this.trtBuildExecutorService.shutdown();
    }

    public static IdentificationStrategyFactory tupleRelationshipStrategy() {
        return TupleRelationshipStrategy::new;
    }

    @Override
    public Optional<int[]> startIdentification(int[] testInput, TestResult result) {
        if (!result.getResultValue().isPresent()) {
            throw new Coffee4JException("Cause of Failure must be present!");
        }
        this.currentlyProcessedTestInput = testInput;
        this.resultOfCurrentlyProcessedTestInput = result;
        this.possiblyInducingCombinations.clear();
        this.currentlySelectedNode = null;
        this.passingTestInputs.addAll(this.coverageMap.getPassingTestInputs());
        this.root = this.buildTupleRelationshipTree(result);
        this.alreadyExecutedTests.clear();
        this.alreadyExecutedTests.add(this.currentlyProcessedTestInput);
        this.chooseTupleFromCurrentTRT();
        if (this.currentlySelectedNode == null) {
            return Optional.empty();
        }
        return this.generateNextTestInputContainingTuple(this.currentlySelectedNode.getCombination(this.currentlyProcessedTestInput), this.alreadyExecutedTests);
    }

    private Optional<int[]> generateNextTestInputContainingTuple(int[] testInput, List<int[]> alreadyExecutedTests) {
        for (int numberOfTries = 0; numberOfTries < 20; ++numberOfTries) {
            Collections.shuffle(this.parameters);
            int[] nextTestInput = Arrays.copyOf(testInput, testInput.length);
            boolean validTestInputFound = true;
            IntListIterator intListIterator = this.parameters.iterator();
            while (intListIterator.hasNext()) {
                int parameter = (Integer)intListIterator.next();
                if (nextTestInput[parameter] != -1) continue;
                Optional<ParameterValuePair> optimalValue = OptimalValue.mostDissimilarForParameter(parameter, this.testModel.getParameterSize(parameter), nextTestInput, alreadyExecutedTests, this.checker);
                if (!optimalValue.isPresent()) {
                    validTestInputFound = false;
                    alreadyExecutedTests.add(nextTestInput);
                    break;
                }
                nextTestInput[optimalValue.get().getParameter()] = optimalValue.get().getValue();
            }
            if (!validTestInputFound) continue;
            return Optional.of(nextTestInput);
        }
        return Optional.empty();
    }

    void chooseTupleFromCurrentTRT() {
        if (this.currentlySelectedNode == null || this.tail < this.head || this.currentlySelectedLongestPath.size() == 1 && !this.currentlySelectedLongestPath.get(0).isUnknown()) {
            this.currentlySelectedLongestPath = this.getLongestPath();
            this.middle = 0;
            this.head = 0;
            this.tail = this.currentlySelectedLongestPath.size() - 1;
        }
        if (this.currentlySelectedNode != null) {
            if (this.currentlySelectedNode.isHealthy()) {
                this.tail = this.middle - 1;
            } else if (this.currentlySelectedNode.isFaulty() || this.currentlySelectedNode.isExceptionInducingCombination()) {
                this.head = this.middle + 1;
            }
            this.middle = (this.head + this.tail) / 2;
        }
        if (!this.currentlySelectedLongestPath.isEmpty()) {
            this.currentlySelectedNode = this.currentlySelectedLongestPath.get(this.middle);
            this.exceptionsTriggeredByCurrentlySelectedNode = new ArrayList<Throwable>();
        } else {
            this.currentlySelectedNode = null;
        }
    }

    List<TupleNode> getLongestPath() {
        this.tempPath = new ArrayList<TupleNode>();
        this.possiblyInducingCombinations.clear();
        this.maximumPathFound = false;
        try {
            this.computeUnknownPaths();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Coffee4JException(e, "Took too long to compute unknown paths!", new Object[0]);
        }
        return this.tempPath;
    }

    void computeUnknownPaths() throws InterruptedException {
        HashSet<TupleNode> collectedInducingCombinations = new HashSet<TupleNode>();
        HashSet longestPaths = new HashSet();
        ExecutorService executorService = Executors.newCachedThreadPool();
        if (this.root.isMinimalInducingTuple()) {
            collectedInducingCombinations.add(this.root);
        }
        for (TupleNode child : this.root.getChildren()) {
            ArrayList<TupleNode> path = new ArrayList<TupleNode>();
            if (child.isUnknown()) {
                path.add(child);
            } else if ((child.isFaulty() || child.isExceptionInducingCombination()) && child.isMinimalInducingTuple()) {
                collectedInducingCombinations.add(child);
            }
            if (child.hasChildren()) {
                Runnable task = () -> {
                    ArrayList<TupleNode> longestPath = new ArrayList<TupleNode>();
                    this.computePathsRecursively(path, child, longestPath, collectedInducingCombinations);
                    longestPaths.add(longestPath);
                };
                executorService.execute(task);
                continue;
            }
            if (path.isEmpty()) continue;
            longestPaths.add(path);
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        while (!executorService.isTerminated()) {
        }
        this.tempPath = !longestPaths.isEmpty() ? (List<Object>)longestPaths.stream().max(Comparator.comparing(List::size)).orElse(new ArrayList()) : new ArrayList<TupleNode>();
        if (this.tempPath.isEmpty() && !collectedInducingCombinations.isEmpty()) {
            collectedInducingCombinations.forEach(fic -> this.possiblyInducingCombinations.put((IntList)new IntArrayList(fic.getCombination(this.currentlyProcessedTestInput)), fic.isExceptionInducingCombination() ? CombinationType.EXCEPTION_INDUCING : CombinationType.FAILURE_INDUCING));
        }
    }

    private void computePathsRecursively(List<TupleNode> list, TupleNode node, List<TupleNode> longestPath, Set<TupleNode> collectedInducingCombinations) {
        if (this.maximumPathFound) {
            return;
        }
        if (!node.hasChildren()) {
            if (list.size() > longestPath.size()) {
                longestPath.clear();
                longestPath.addAll(list);
                if (list.size() == this.templateNodes.size() - 1) {
                    this.maximumPathFound = true;
                    return;
                }
            }
            if (node.isMinimalInducingTuple()) {
                collectedInducingCombinations.add(node);
            }
        } else {
            for (TupleNode child : node.getChildren()) {
                if (this.maximumPathFound) {
                    return;
                }
                if (child.isUnknown()) {
                    ArrayList<TupleNode> path = new ArrayList<TupleNode>(list);
                    path.add(child);
                    this.computePathsRecursively(path, child, longestPath, collectedInducingCombinations);
                    continue;
                }
                if (!list.isEmpty() && list.size() > longestPath.size()) {
                    longestPath.clear();
                    longestPath.addAll(list);
                    if (list.size() == this.templateNodes.size() - 1) {
                        this.maximumPathFound = true;
                        return;
                    }
                }
                if (!child.isFaulty() && !child.isExceptionInducingCombination()) continue;
                if (child.isMinimalInducingTuple()) {
                    collectedInducingCombinations.add(child);
                    continue;
                }
                this.computePathsRecursively(new ArrayList<TupleNode>(), child, longestPath, collectedInducingCombinations);
            }
        }
    }

    TupleNode buildTupleRelationshipTree(TestResult result) {
        while (!this.trtBuildExecutorService.isTerminated()) {
        }
        if (this.firstRound) {
            int finalI;
            this.firstRound = false;
            ExecutorService es = Executors.newCachedThreadPool();
            int i = 0;
            while (i < this.templateNodes.size() - 1) {
                finalI = i++;
                Runnable collectChildNodes = () -> this.templateNodes.get(finalI).forEach(TupleNode::getChildren);
                es.execute(collectChildNodes);
            }
            i = this.templateNodes.size() - 1;
            while (i > 0) {
                finalI = i--;
                Runnable collectParentNodes = () -> this.templateNodes.get(finalI).forEach(TupleNode::getParents);
                es.execute(collectParentNodes);
            }
            es.shutdown();
        }
        TupleNode trt = new TupleNode(this.templateTRT);
        this.updateKnownPassingTuples(this.templateNodes);
        Optional<Throwable> optCause = result.getResultValue();
        if (!optCause.isPresent()) {
            throw new Coffee4JException("Cause for TestResult must not be empty!");
        }
        if (optCause.get() instanceof ErrorConstraintException) {
            trt.setAsExceptionInducingCombination();
        } else {
            trt.setFaulty();
        }
        return trt;
    }

    void updateKnownPassingTuples(List<Set<TupleNode>> nodes) {
        for (Set<TupleNode> nodeSet : nodes) {
            block1: for (TupleNode node : nodeSet) {
                node.setAsUnknown();
                for (IntList passingTestInput : this.passingTestInputs) {
                    if (!CombinationUtil.contains(passingTestInput.toIntArray(), node.getCombination(this.currentlyProcessedTestInput))) continue;
                    node.setHealthy();
                    continue block1;
                }
            }
        }
    }

    @Override
    public Optional<int[]> restartIdentification() {
        return this.startIdentification(this.currentlyProcessedTestInput, this.resultOfCurrentlyProcessedTestInput);
    }

    @Override
    public Optional<int[]> generateNextTestInputForIdentification(int[] testInput, TestResult testResult) {
        if (testResult.isSuccessful()) {
            this.passingTestInputs.add((IntList)new IntArrayList(testInput));
            this.currentlySelectedNode.setHealthy();
            if (this.currentlySelectedNode.hasChildren()) {
                this.currentlySelectedNode.getChildren().forEach(this::updateChildren);
            }
            this.iteration = 1;
            this.alreadyExecutedTests.clear();
            this.alreadyExecutedTests.add(this.currentlyProcessedTestInput);
        } else {
            TupleStatus status;
            long failures;
            if (this.iteration < 50) {
                ++this.iteration;
                this.alreadyExecutedTests.add(testInput);
                this.exceptionsTriggeredByCurrentlySelectedNode.add(testResult.getResultValue().orElseGet(ErrorConstraintException::new));
                return this.generateNextTestInputContainingTuple(this.currentlySelectedNode.getCombination(this.currentlyProcessedTestInput), this.alreadyExecutedTests);
            }
            long errorExceptions = this.exceptionsTriggeredByCurrentlySelectedNode.stream().filter(exception -> exception instanceof ErrorConstraintException).count();
            if (errorExceptions > (failures = (long)this.exceptionsTriggeredByCurrentlySelectedNode.size() - errorExceptions)) {
                this.currentlySelectedNode.setAsExceptionInducingCombination();
                status = TupleStatus.EXCEPTIONAL_COMBINATION;
            } else {
                this.currentlySelectedNode.setFaulty();
                status = TupleStatus.FAULTY;
            }
            if (this.currentlySelectedNode.hasParents()) {
                this.currentlySelectedNode.getParents().forEach(parent -> this.updateParents((TupleNode)parent, status));
            }
            this.iteration = 1;
            this.alreadyExecutedTests.clear();
            this.alreadyExecutedTests.add(this.currentlyProcessedTestInput);
        }
        this.chooseTupleFromCurrentTRT();
        if (this.currentlySelectedNode == null) {
            return Optional.empty();
        }
        return this.generateNextTestInputContainingTuple(this.currentlySelectedNode.getCombination(this.currentlyProcessedTestInput), this.alreadyExecutedTests);
    }

    private void updateChildren(TupleNode node) {
        if (node.isHealthy()) {
            return;
        }
        node.setHealthy();
        if (node.hasChildren()) {
            node.getChildren().forEach(this::updateChildren);
        }
    }

    private void updateParents(TupleNode node, TupleStatus status) {
        if (node.getStatus() == status) {
            return;
        }
        if (status == TupleStatus.EXCEPTIONAL_COMBINATION) {
            node.setAsExceptionInducingCombination();
        } else if (status == TupleStatus.FAULTY) {
            node.setFaulty();
        } else {
            throw new Coffee4JException("status must be FAULTY or EXCEPTIONAL_COMBINATION!");
        }
        if (node.hasParents()) {
            node.getParents().forEach(parent -> this.updateParents((TupleNode)parent, status));
        }
    }

    @Override
    public Map<IntList, CombinationType> getIdentifiedCombinations() {
        return this.possiblyInducingCombinations;
    }

    public String toString() {
        return "TupleRelationshipStrategy";
    }
}

