/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.manager;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.constraint.ForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.Phase;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.AbstractInterleavingManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.GeneratingInterleavingCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.util.TupleBuilderUtil;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractGeneratingInterleavingManager
extends AbstractInterleavingManager
implements GeneratingInterleavingCombinatorialTestManager {
    private final int numberOfParameters;
    private final int[] parameterSizes;
    private final ClassificationStrategy classificationStrategy;
    protected Map<int[], Class<? extends Throwable>> minimalExceptionInducingCombinations = new HashMap<int[], Class<? extends Throwable>>();
    protected Set<int[]> minimalExceptionInducingCombinationsToCheck;

    AbstractGeneratingInterleavingManager(InterleavingCombinatorialTestConfiguration configuration, CompleteTestModel testModel) {
        super(configuration, testModel);
        this.numberOfParameters = testModel.getNumberOfParameters();
        this.parameterSizes = Preconditions.notNull(testModel.getParameterSizes());
        this.classificationStrategy = Preconditions.notNull(configuration.getClassificationStrategyFactory()).create(ClassificationConfiguration.configuration().constraintChecker(configuration.getConstraintCheckerFactory().createConstraintChecker(testModel)).testModel(testModel).build());
        assert (this.numberOfParameters > 0);
    }

    @Override
    public Optional<int[]> initializeClassification(Map<int[], TestResult> errorConstraintExceptionCausingTestInputs) {
        this.currentPhase = Phase.CLASSIFICATION;
        HashMap<int[], Throwable> inputs = new HashMap<int[], Throwable>();
        for (Map.Entry<int[], TestResult> input : errorConstraintExceptionCausingTestInputs.entrySet()) {
            input.getValue().getResultValue().ifPresent(throwable -> inputs.put((int[])input.getKey(), throwable.getCause()));
        }
        Optional<int[]> nextTestInput = this.classificationStrategy.startClassification(inputs, this.postProcessExceptionInducingCombinations(), this.failureInducingCombinations);
        return this.checkTestInputForClassification(nextTestInput);
    }

    @Override
    public Optional<int[]> generateNextTestInput(int[] testInput, TestResult result) {
        switch (this.currentPhase) {
            case GENERATION: {
                return this.generateNextTestInput();
            }
            case IDENTIFICATION: {
                return this.generateNextTestInputForIdentification(testInput, result);
            }
            case VERIFICATION: {
                return this.generateNextTestInputForFeedbackChecking(testInput, result);
            }
            case CLASSIFICATION: {
                return this.generateNextTestInputForClassification(testInput, result);
            }
        }
        throw new Coffee4JException("Unknown Phase!");
    }

    @Override
    protected Optional<int[]> generateNextTestInput() {
        Optional<int[]> nextTestInput = Optional.empty();
        if (!this.coverageMap.allCombinationsCovered()) {
            nextTestInput = this.testInputGenerationStrategy.generateNextTestInput();
        }
        if (!nextTestInput.isPresent()) {
            this.currentPhase = Phase.CLASSIFICATION;
        }
        return nextTestInput;
    }

    @Override
    public Map<int[], Class<? extends Throwable>> getMinimalExceptionInducingCombinations() {
        return this.minimalExceptionInducingCombinations;
    }

    private Optional<int[]> generateNextTestInputForClassification(int[] testInput, TestResult result) {
        Optional<int[]> nextTestInput = this.classificationStrategy.generateNextTestInputForClassification(testInput, result);
        return this.checkTestInputForClassification(nextTestInput);
    }

    private Optional<int[]> checkTestInputForClassification(Optional<int[]> nextTestInput) {
        if (!nextTestInput.isPresent()) {
            this.minimalExceptionInducingCombinations = this.classificationStrategy.getClassifiedExceptionInducingCombinations();
            this.terminateInterleavingGroup();
        }
        return nextTestInput;
    }

    protected List<int[]> postProcessExceptionInducingCombinations() {
        Preconditions.check(this.checker instanceof ForbiddenTuplesChecker);
        Set<IntList> initialForbiddenTuples = ((ForbiddenTuplesChecker)this.checker).getInitialForbiddenTuples();
        Set exceptionInducingCombinations = this.minimalExceptionInducingCombinations.keySet().stream().map(IntArrayList::new).collect(Collectors.toSet());
        HashSet<IntList> derivedTuples = new HashSet<IntList>();
        HashSet<IntList> usedForDeriving = new HashSet<IntList>();
        for (IntList generatedTuple : exceptionInducingCombinations) {
            for (int param = 0; param < this.numberOfParameters; ++param) {
                IntArraySet usedValues = new IntArraySet();
                if (generatedTuple.getInt(param) == -1) continue;
                ArrayList<Collection<IntList>> forbiddenTuplesForParameter = new ArrayList<Collection<IntList>>(this.parameterSizes[param]);
                for (int i = 0; i < this.parameterSizes[param]; ++i) {
                    forbiddenTuplesForParameter.add(new HashSet());
                }
                usedValues.add(generatedTuple.getInt(param));
                ((Collection)forbiddenTuplesForParameter.get(generatedTuple.getInt(param))).add(generatedTuple);
                for (IntList initialTuple : initialForbiddenTuples) {
                    if (initialTuple.getInt(param) == -1) continue;
                    ((Collection)forbiddenTuplesForParameter.get(initialTuple.getInt(param))).add(initialTuple);
                    usedValues.add(initialTuple.getInt(param));
                }
                if (usedValues.size() != this.parameterSizes[param]) continue;
                derivedTuples.addAll(this.deriveNewTuplesUsingParameter(param, forbiddenTuplesForParameter));
                usedForDeriving.add(generatedTuple);
            }
        }
        derivedTuples.removeAll(usedForDeriving);
        exceptionInducingCombinations.removeAll(derivedTuples);
        return exceptionInducingCombinations.stream().map(IntCollection::toIntArray).collect(Collectors.toList());
    }

    private Collection<IntList> deriveNewTuplesUsingParameter(int param, List<Collection<IntList>> forbiddenTuplesForParameter) {
        HashSet<Collection<IntList>> forbiddenSet = new HashSet<Collection<IntList>>();
        for (Collection<IntList> set : forbiddenTuplesForParameter) {
            HashSet<IntArrayList> newSet = new HashSet<IntArrayList>();
            for (IntList tuple : set) {
                IntArrayList newTuple = new IntArrayList(tuple);
                newTuple.set(param, -1);
                newSet.add(newTuple);
            }
            forbiddenSet.add(newSet);
        }
        return TupleBuilderUtil.buildCartesianProduct(forbiddenSet, this.numberOfParameters);
    }
}

