/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.manager;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.interleaving.InterleavingCombinatorialTestGroup;
import de.rwth.swc.coffee4j.algorithmic.interleaving.Phase;
import de.rwth.swc.coffee4j.algorithmic.interleaving.feedback.FeedbackCheckingConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.feedback.FeedbackCheckingStrategy;
import de.rwth.swc.coffee4j.algorithmic.interleaving.generator.TestInputGenerationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.generator.TestInputGenerationStrategy;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.report.EmptyInterleavingGenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.interleaving.report.InterleavingGenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

abstract class AbstractInterleavingManager
implements InterleavingCombinatorialTestManager {
    protected final InterleavingGenerationReporter reporter;
    protected final CoverageMap coverageMap;
    protected final ConstraintChecker checker;
    protected final TestInputGenerationStrategy testInputGenerationStrategy;
    protected final IdentificationStrategy identificationStrategy;
    private final FeedbackCheckingStrategy feedbackCheckingStrategy;
    protected final InterleavingCombinatorialTestGroup testGroup;
    private boolean failureInducingCombinationFound;
    protected Set<int[]> failureInducingCombinationsToCheck;
    protected final Set<int[]> failureInducingCombinations = new HashSet<int[]>();
    protected final List<int[]> combinationsToCheck = new ArrayList<int[]>();
    private boolean firstCheckingRound = true;
    private int[] currentlyCheckedPossiblyFailingTuple = null;
    private int[] currentlyCheckedFailingTest;
    private Map<IntList, Integer> falseNegatives = new HashMap<IntList, Integer>();
    protected Phase currentPhase = Phase.GENERATION;
    protected boolean testInputHasFailed = false;

    AbstractInterleavingManager(InterleavingCombinatorialTestConfiguration configuration, CompleteTestModel testModel) {
        this.reporter = configuration.getGenerationReporter().orElse(new EmptyInterleavingGenerationReporter());
        this.checker = configuration.getConstraintCheckerFactory().createConstraintChecker(testModel);
        this.coverageMap = new CoverageMap(testModel.getParameterSizes(), testModel.getPositiveTestingStrength(), this.checker);
        this.testInputGenerationStrategy = Preconditions.notNull(configuration.getTestInputGenerationStrategyFactory()).create(TestInputGenerationConfiguration.configuration().constraintChecker(this.checker).testModel(testModel).coverageMap(this.coverageMap).build());
        this.identificationStrategy = Preconditions.notNull(configuration.getIdentificationStrategyFactory()).create(IdentificationConfiguration.configuration().constraintChecker(this.checker).testModel(testModel).coverageMap(this.coverageMap).build());
        this.feedbackCheckingStrategy = Preconditions.notNull(configuration.getFeedbackCheckingStrategyFactory()).create(FeedbackCheckingConfiguration.configuration().constraintChecker(this.checker).testModel(testModel).coverageMap(this.coverageMap).build());
        this.testGroup = new InterleavingCombinatorialTestGroup("Interleaving Combinatorial Test Group", this.testInputGenerationStrategy, this.identificationStrategy, this.feedbackCheckingStrategy);
        this.reporter.interleavingGroupGenerated(this.testGroup);
    }

    @Override
    public Optional<int[]> generateNextTestInput(int[] testInput, TestResult result) {
        switch (this.currentPhase) {
            case GENERATION: {
                return this.generateNextTestInput();
            }
            case IDENTIFICATION: {
                return this.generateNextTestInputForIdentification(testInput, result);
            }
            case VERIFICATION: {
                return this.generateNextTestInputForFeedbackChecking(testInput, result);
            }
        }
        throw new Coffee4JException("Unknown Phase!");
    }

    @Override
    public Optional<int[]> initializeIdentification(int[] testInput, TestResult result) {
        this.currentPhase = Phase.IDENTIFICATION;
        this.testInputHasFailed = true;
        this.resetCombinationsToBeChecked();
        this.currentlyCheckedFailingTest = Arrays.copyOf(testInput, testInput.length);
        this.failureInducingCombinationFound = false;
        Optional<int[]> nextTestInput = this.identificationStrategy.startIdentification(testInput, result);
        this.reporter.identificationStarted(this.testGroup, testInput);
        return this.checkTestInputForIdentification(nextTestInput);
    }

    @Override
    public Optional<int[]> reinitializeIdentification() {
        this.currentPhase = Phase.IDENTIFICATION;
        this.resetCombinationsToBeChecked();
        Optional<int[]> nextTestInput = this.identificationStrategy.restartIdentification();
        return this.checkTestInputForIdentification(nextTestInput);
    }

    @Override
    public Optional<int[]> initializeFeedbackChecking() {
        this.currentPhase = Phase.VERIFICATION;
        if (this.firstCheckingRound) {
            if (this.noCombinationsToBeCheckedPresent()) {
                this.currentPhase = Phase.GENERATION;
                return Optional.empty();
            }
            this.determineCombinationsToBeChecked();
            this.firstCheckingRound = false;
            this.failureInducingCombinationFound = true;
        } else if (this.combinationsToCheck.isEmpty()) {
            if (this.failureInducingCombinationFound) {
                this.updateCoverage();
            }
            this.firstCheckingRound = true;
            this.currentPhase = Phase.GENERATION;
            return Optional.empty();
        }
        this.currentlyCheckedPossiblyFailingTuple = this.combinationsToCheck.remove(0);
        Optional<int[]> nextTestInput = this.feedbackCheckingStrategy.startFeedbackChecking(this.currentlyCheckedPossiblyFailingTuple, this.currentlyCheckedFailingTest);
        this.reporter.checkingStarted(this.testGroup, this.currentlyCheckedPossiblyFailingTuple);
        return this.checkTestInputForFeedbackChecking(nextTestInput);
    }

    @Override
    public void updateCoverage(int[] combination) {
        this.coverageMap.updateCoverage(combination);
    }

    @Override
    public boolean combinationIdentified() {
        return this.failureInducingCombinationFound;
    }

    protected Optional<int[]> generateNextTestInput() {
        Optional<int[]> nextTestInput = Optional.empty();
        if (!this.coverageMap.allCombinationsCovered() && !this.testInputHasFailed) {
            nextTestInput = this.testInputGenerationStrategy.generateNextTestInput();
        }
        if (!nextTestInput.isPresent()) {
            this.terminateInterleavingGroup();
        }
        return nextTestInput;
    }

    protected Optional<int[]> generateNextTestInputForIdentification(int[] testInput, TestResult result) {
        Optional<int[]> nextTestInput = this.identificationStrategy.generateNextTestInputForIdentification(testInput, result);
        return this.checkTestInputForIdentification(nextTestInput);
    }

    private Optional<int[]> checkTestInputForIdentification(Optional<int[]> nextTestInput) {
        if (!nextTestInput.isPresent()) {
            this.terminateIdentification();
        } else {
            this.reporter.identificationTestInputGenerated(this.testGroup, nextTestInput.get());
        }
        return nextTestInput;
    }

    protected Optional<int[]> generateNextTestInputForFeedbackChecking(int[] testInput, TestResult result) {
        if (result.isSuccessful()) {
            this.falseNegatives.put((IntList)new IntArrayList(this.currentlyCheckedPossiblyFailingTuple), this.falseNegatives.getOrDefault(new IntArrayList(this.currentlyCheckedPossiblyFailingTuple), 0) + 1);
            if (this.falseNegatives.containsKey(new IntArrayList(this.currentlyCheckedPossiblyFailingTuple)) && (!Arrays.equals(this.currentlyCheckedPossiblyFailingTuple, CombinationUtil.emptyCombination(this.currentlyCheckedPossiblyFailingTuple.length)) && this.falseNegatives.get(new IntArrayList(this.currentlyCheckedPossiblyFailingTuple)) > 10 || this.falseNegatives.get(new IntArrayList(this.currentlyCheckedPossiblyFailingTuple)) > 30)) {
                this.reporter.checkingFinished(this.testGroup, this.currentlyCheckedPossiblyFailingTuple, true);
                this.falseNegatives.remove(new IntArrayList(this.currentlyCheckedPossiblyFailingTuple));
            } else {
                this.reporter.checkingFinished(this.testGroup, this.currentlyCheckedPossiblyFailingTuple, false);
                this.failureInducingCombinationFound = false;
            }
            this.currentPhase = Phase.GENERATION;
            return Optional.empty();
        }
        Optional<int[]> nextTestInput = this.feedbackCheckingStrategy.generateNextTestInputForChecking(testInput, result);
        return this.checkTestInputForFeedbackChecking(nextTestInput);
    }

    private Optional<int[]> checkTestInputForFeedbackChecking(Optional<int[]> nextTestInput) {
        if (!nextTestInput.isPresent()) {
            this.falseNegatives = new HashMap<IntList, Integer>();
            this.reporter.checkingFinished(this.testGroup, this.currentlyCheckedPossiblyFailingTuple, true);
            this.currentPhase = Phase.GENERATION;
        }
        return nextTestInput;
    }

    void updateCoverageAfterFailureInducingCombinationIsIdentified(Set<int[]> possibleMinimalFailureInducingCombinations) {
        possibleMinimalFailureInducingCombinations.forEach(this.checker::addConstraint);
        this.coverageMap.updateCoverage();
    }

    protected abstract void resetCombinationsToBeChecked();

    protected abstract void updateCoverage();

    protected abstract void determineCombinationsToBeChecked();

    protected abstract boolean noCombinationsToBeCheckedPresent();

    protected abstract void terminateInterleavingGroup();

    protected abstract void terminateIdentification();
}

