/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.manager;

import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.CombinationType;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.AbstractGeneratingInterleavingManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.GeneratingInterleavingManagerFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestConfiguration;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashSet;
import java.util.Map;

public class DefaultGeneratingInterleavingManager
extends AbstractGeneratingInterleavingManager {
    DefaultGeneratingInterleavingManager(InterleavingCombinatorialTestConfiguration configuration, CompleteTestModel testModel) {
        super(configuration, testModel);
    }

    @Override
    protected void terminateInterleavingGroup() {
        this.reporter.interleavingGroupFinished(this.testGroup, this.minimalExceptionInducingCombinations, this.failureInducingCombinations);
    }

    @Override
    protected void terminateIdentification() {
        for (Map.Entry<IntList, CombinationType> combination : this.identificationStrategy.getIdentifiedCombinations().entrySet()) {
            if (combination.getValue() == CombinationType.EXCEPTION_INDUCING) {
                this.minimalExceptionInducingCombinationsToCheck.add(combination.getKey().toIntArray());
                continue;
            }
            this.failureInducingCombinationsToCheck.add(combination.getKey().toIntArray());
        }
        this.reporter.identificationFinished(this.testGroup, this.minimalExceptionInducingCombinationsToCheck, this.failureInducingCombinationsToCheck);
    }

    @Override
    protected void resetCombinationsToBeChecked() {
        this.minimalExceptionInducingCombinationsToCheck = new HashSet();
        this.failureInducingCombinationsToCheck = new HashSet();
    }

    @Override
    protected boolean noCombinationsToBeCheckedPresent() {
        return this.minimalExceptionInducingCombinationsToCheck.isEmpty() && this.failureInducingCombinationsToCheck.isEmpty();
    }

    @Override
    protected void determineCombinationsToBeChecked() {
        this.combinationsToCheck.addAll(this.minimalExceptionInducingCombinationsToCheck);
        this.combinationsToCheck.addAll(this.failureInducingCombinationsToCheck);
    }

    @Override
    protected void updateCoverage() {
        this.updateCoverageAfterFailureInducingCombinationIsIdentified(this.minimalExceptionInducingCombinationsToCheck);
        this.minimalExceptionInducingCombinationsToCheck.forEach(combination -> this.minimalExceptionInducingCombinations.put(combination, null));
        this.updateCoverageAfterFailureInducingCombinationIsIdentified(this.failureInducingCombinationsToCheck);
        this.failureInducingCombinations.addAll(this.failureInducingCombinationsToCheck);
    }

    public static GeneratingInterleavingManagerFactory managerFactory() {
        return DefaultGeneratingInterleavingManager::new;
    }
}

