/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.manager;

import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.feedback.FeedbackCheckingStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.generator.TestInputGenerationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.report.InterleavingGenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Objects;
import java.util.Optional;

public final class InterleavingCombinatorialTestConfiguration {
    private final TestInputGenerationStrategyFactory testInputGenerationStrategyFactory;
    private final IdentificationStrategyFactory identificationStrategyFactory;
    private final FeedbackCheckingStrategyFactory feedbackCheckingStrategyFactory;
    private final ConstraintCheckerFactory constraintCheckerFactory;
    private final ClassificationStrategyFactory classificationStrategyFactory;
    private final InterleavingGenerationReporter generationReporter;

    public InterleavingCombinatorialTestConfiguration(TestInputGenerationStrategyFactory testInputGenerationStrategyFactory, IdentificationStrategyFactory identificationStrategyFactory, FeedbackCheckingStrategyFactory feedbackCheckingStrategyFactory, ClassificationStrategyFactory classificationStrategyFactory, ConstraintCheckerFactory constraintCheckerFactory, InterleavingGenerationReporter generationReporter) {
        this.testInputGenerationStrategyFactory = Preconditions.notNull(testInputGenerationStrategyFactory);
        this.identificationStrategyFactory = Preconditions.notNull(identificationStrategyFactory);
        this.feedbackCheckingStrategyFactory = Preconditions.notNull(feedbackCheckingStrategyFactory);
        this.constraintCheckerFactory = Preconditions.notNull(constraintCheckerFactory);
        this.classificationStrategyFactory = Preconditions.notNull(classificationStrategyFactory);
        this.generationReporter = generationReporter;
    }

    public TestInputGenerationStrategyFactory getTestInputGenerationStrategyFactory() {
        return this.testInputGenerationStrategyFactory;
    }

    public IdentificationStrategyFactory getIdentificationStrategyFactory() {
        return this.identificationStrategyFactory;
    }

    public FeedbackCheckingStrategyFactory getFeedbackCheckingStrategyFactory() {
        return this.feedbackCheckingStrategyFactory;
    }

    public ConstraintCheckerFactory getConstraintCheckerFactory() {
        return this.constraintCheckerFactory;
    }

    public ClassificationStrategyFactory getClassificationStrategyFactory() {
        return this.classificationStrategyFactory;
    }

    public Optional<InterleavingGenerationReporter> getGenerationReporter() {
        return Optional.ofNullable(this.generationReporter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterleavingCombinatorialTestConfiguration)) {
            return false;
        }
        InterleavingCombinatorialTestConfiguration that = (InterleavingCombinatorialTestConfiguration)o;
        return Objects.equals(this.testInputGenerationStrategyFactory, that.testInputGenerationStrategyFactory) && Objects.equals(this.identificationStrategyFactory, that.identificationStrategyFactory) && Objects.equals(this.feedbackCheckingStrategyFactory, that.feedbackCheckingStrategyFactory) && Objects.equals(this.constraintCheckerFactory, that.constraintCheckerFactory) && Objects.equals(this.classificationStrategyFactory, that.classificationStrategyFactory) && Objects.equals(this.generationReporter, that.generationReporter);
    }

    public int hashCode() {
        return Objects.hash(this.testInputGenerationStrategyFactory, this.identificationStrategyFactory, this.feedbackCheckingStrategyFactory, this.constraintCheckerFactory, this.classificationStrategyFactory, this.generationReporter);
    }

    public String toString() {
        return "InterleavingCombinatorialTestConfiguration{testInputGenerationStrategyFactory=" + this.testInputGenerationStrategyFactory + ", identificationStrategyFactory=" + this.identificationStrategyFactory + ", feedbackCheckingStrategyFactory=" + this.feedbackCheckingStrategyFactory + ", classificationStrategyFactory=" + this.classificationStrategyFactory + ", constraintCheckerFactory=" + this.constraintCheckerFactory + ", generationReporter=" + this.generationReporter + "}";
    }
}

