/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.util;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class OptimalValue {
    public Optional<ParameterValuePair> forParameter(int parameter, int numberOfValues, IntSet forbiddenValues, int[] testInput, CoverageMap coverageMap, ConstraintChecker checker) {
        int[] candidateTestInput = Arrays.copyOf(testInput, testInput.length);
        int optimalValue = -1;
        long maximumNumberOfCoveredCombinations = -1L;
        IntArrayList possibleValues = new IntArrayList(numberOfValues);
        for (int i = 0; i < numberOfValues; ++i) {
            if (forbiddenValues.contains(i)) continue;
            possibleValues.add(i);
        }
        Collections.shuffle(possibleValues);
        IntListIterator intListIterator = possibleValues.iterator();
        while (intListIterator.hasNext()) {
            int value = (Integer)intListIterator.next();
            if (!checker.isExtensionValid(candidateTestInput, parameter, value)) continue;
            candidateTestInput[parameter] = value;
            long numberOfCoveredCombinations = coverageMap.getNumberOfCoveredCombinationsByTestInput(candidateTestInput);
            if (numberOfCoveredCombinations <= maximumNumberOfCoveredCombinations) continue;
            optimalValue = value;
            maximumNumberOfCoveredCombinations = numberOfCoveredCombinations;
        }
        if (optimalValue == -1) {
            return Optional.empty();
        }
        return Optional.of(new ParameterValuePair(parameter, optimalValue));
    }

    public static Optional<ParameterValuePair> mostDissimilarForParameter(int parameter, int numberOfValues, int[] testInput, List<int[]> executedTestInputs, ConstraintChecker checker) {
        int[] candidateTestInput = Arrays.copyOf(testInput, testInput.length);
        int optimalValue = -1;
        int minimalNumberOfSimilarTestCases = Integer.MAX_VALUE;
        IntArrayList possibleValues = new IntArrayList();
        IntStream.range(0, numberOfValues).forEach(arg_0 -> ((IntArrayList)possibleValues).add(arg_0));
        Collections.shuffle(possibleValues);
        IntListIterator intListIterator = possibleValues.iterator();
        while (intListIterator.hasNext()) {
            int value = (Integer)intListIterator.next();
            if (!checker.isExtensionValid(candidateTestInput, parameter, value)) continue;
            candidateTestInput[parameter] = value;
            int valueToCheck = value;
            int numberOfSimilarTestCases = (int)executedTestInputs.stream().filter(input -> input[parameter] == valueToCheck).count();
            if (numberOfSimilarTestCases >= minimalNumberOfSimilarTestCases) continue;
            optimalValue = value;
            minimalNumberOfSimilarTestCases = numberOfSimilarTestCases;
        }
        if (optimalValue == -1) {
            return Optional.empty();
        }
        return Optional.of(new ParameterValuePair(parameter, optimalValue));
    }

    public static Optional<ParameterValuePair> valueForParameter(int parameter, int numberOfValues, int[] testInput, Set<IntList> executedTestInputs, ConstraintChecker checker) {
        int[] candidateTestInput = Arrays.copyOf(testInput, testInput.length);
        IntArraySet values = new IntArraySet();
        IntStream.range(0, numberOfValues).forEach(arg_0 -> ((IntSet)values).add(arg_0));
        values.removeAll((Collection)executedTestInputs.stream().map(IntCollection::toIntArray).filter(input -> CombinationUtil.contains(input, testInput)).map(input -> input[parameter]).collect(Collectors.toList()));
        IntArrayList possibleValues = new IntArrayList((IntCollection)values);
        Collections.shuffle(possibleValues);
        IntListIterator intListIterator = possibleValues.iterator();
        while (intListIterator.hasNext()) {
            int value = (Integer)intListIterator.next();
            if (!checker.isExtensionValid(candidateTestInput, parameter, value)) continue;
            candidateTestInput[parameter] = value;
            return Optional.of(new ParameterValuePair(parameter, value));
        }
        return Optional.empty();
    }
}

