/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.interleaving.util;

import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class TupleBuilderUtil {
    private TupleBuilderUtil() {
    }

    public static Collection<IntList> buildCartesianProduct(Set<Collection<IntList>> tuplesSet, int numberOfParameters) {
        Collection tuple2;
        Collection tuple1;
        ArrayList<Collection<IntList>> tupleList = new ArrayList<Collection<IntList>>(tuplesSet);
        while (tupleList.size() > 2) {
            tuple1 = (Collection)tupleList.remove(0);
            Set<IntList> productSet = TupleBuilderUtil.buildProduct(tuple1, tuple2 = (Collection)tupleList.remove(0));
            if (!productSet.isEmpty()) {
                tupleList.add(productSet);
                continue;
            }
            return Collections.emptySet();
        }
        if (tupleList.size() == 2) {
            tuple1 = (Collection)tupleList.remove(0);
            tuple2 = (Collection)tupleList.remove(0);
            return TupleBuilderUtil.buildProduct(tuple1, tuple2);
        }
        if (tupleList.size() == 1) {
            Collection forbiddenTuples = (Collection)tupleList.remove(0);
            if (forbiddenTuples.size() == 1 && forbiddenTuples.contains(new IntArrayList(CombinationUtil.emptyCombination(numberOfParameters)))) {
                return Collections.emptySet();
            }
            return forbiddenTuples;
        }
        return Collections.emptySet();
    }

    private static Set<IntList> buildProduct(Collection<IntList> set1, Collection<IntList> set2) {
        HashSet<IntList> productSet = new HashSet<IntList>();
        for (IntList tuple1 : set1) {
            for (IntList tuple2 : set2) {
                IntList tupleProduct = TupleBuilderUtil.combineTuples(tuple1, tuple2);
                if (tupleProduct == null) continue;
                productSet.add(tupleProduct);
            }
        }
        return productSet;
    }

    private static IntList combineTuples(IntList tuple1, IntList tuple2) {
        IntArrayList tupleProduct = new IntArrayList(tuple1);
        for (int i = 0; i < tuple1.size(); ++i) {
            if (tuple1.getInt(i) == -1 || tuple1.getInt(i) == tuple2.getInt(i)) {
                tupleProduct.set(i, tuple2.getInt(i));
                continue;
            }
            if (tuple2.getInt(i) == -1) continue;
            return null;
        }
        if (TupleBuilderUtil.isEmptyCombination((IntList)tupleProduct)) {
            return null;
        }
        return tupleProduct;
    }

    private static boolean isEmptyCombination(IntList tupleProduct) {
        for (int param = 0; param < tupleProduct.size(); ++param) {
            if (tupleProduct.getInt(param) == -1) continue;
            return false;
        }
        return true;
    }
}

