/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.model;

import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintList;
import de.rwth.swc.coffee4j.algorithmic.constraint.HardConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveSeed;
import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveStrengthGroup;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleMaps;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CompleteTestModel
implements TestModel {
    public static final int POSITIVE_TESTS_ID = -1;
    private final int positiveTestingStrength;
    private final int negativeTestingStrength;
    private final int[] parameterSizes;
    private final List<TupleList> exclusionTupleLists;
    private final List<TupleList> errorTupleLists;
    private final ConstraintList lazyExclusionConstraints;
    private final ConstraintList lazyErrorConstraints;
    private final Int2ObjectMap<Int2DoubleMap> weights;
    private final Int2ObjectMap<List<PrimitiveSeed>> seeds;
    private final Int2ObjectMap<List<PrimitiveStrengthGroup>> mixedStrengthGroups;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CompleteTestModel oldModel) {
        return new Builder().positiveTestingStrength(oldModel.positiveTestingStrength).negativeTestingStrength(oldModel.negativeTestingStrength).parameterSizes(oldModel.parameterSizes).exclusionTupleLists(oldModel.exclusionTupleLists).errorTupleLists(oldModel.errorTupleLists).weights(oldModel.weights).seeds(oldModel.seeds).mixedStrengthGroups(oldModel.mixedStrengthGroups);
    }

    private CompleteTestModel(Builder builder) {
        Preconditions.notNull(builder, "builder");
        Preconditions.notNull(builder.parameterSizes, "parameterSizes");
        Preconditions.check(builder.parameterSizes.length > 0, "too few parameters");
        Preconditions.check(builder.positiveTestingStrength >= 0, "negative positive testing strength");
        Preconditions.check(builder.positiveTestingStrength <= builder.parameterSizes.length, "positive testing strength too high");
        Preconditions.check(builder.negativeTestingStrength >= 0, "negative negative testing strength");
        Preconditions.check(builder.negativeTestingStrength <= builder.parameterSizes.length, "negative testing strength too high");
        CompleteTestModel.checkParameterSizes(builder.parameterSizes);
        CompleteTestModel.checkExclusionTupleIdentifier(builder.parameterSizes, builder.exclusionTupleLists);
        CompleteTestModel.checkExclusionTupleIdentifier(builder.parameterSizes, builder.errorTupleLists);
        CompleteTestModel.checkTuplesListIds(builder.exclusionTupleLists, builder.errorTupleLists);
        this.positiveTestingStrength = builder.positiveTestingStrength;
        this.negativeTestingStrength = builder.negativeTestingStrength;
        this.parameterSizes = Arrays.copyOf(builder.parameterSizes, builder.parameterSizes.length);
        this.exclusionTupleLists = new ArrayList<TupleList>(builder.exclusionTupleLists);
        this.errorTupleLists = new ArrayList<TupleList>(builder.errorTupleLists);
        this.lazyExclusionConstraints = new ConstraintList(this.exclusionTupleLists);
        this.lazyErrorConstraints = new ConstraintList(this.errorTupleLists);
        this.weights = new Int2ObjectOpenHashMap(builder.weights.size());
        for (Int2ObjectMap.Entry builderParameterEntry : builder.weights.int2ObjectEntrySet()) {
            Int2DoubleMap parameterEntry = (Int2DoubleMap)this.weights.computeIfAbsent(builderParameterEntry.getIntKey(), key -> new Int2DoubleOpenHashMap(((Int2DoubleMap)builderParameterEntry.getValue()).size()));
            for (Int2DoubleMap.Entry builderValueEntry : ((Int2DoubleMap)builderParameterEntry.getValue()).int2DoubleEntrySet()) {
                parameterEntry.put(builderValueEntry.getIntKey(), builderValueEntry.getDoubleValue());
            }
        }
        this.seeds = new Int2ObjectOpenHashMap(builder.seeds.size());
        for (Int2ObjectMap.Entry errorConstraintSeeds : builder.seeds.int2ObjectEntrySet()) {
            this.seeds.put(errorConstraintSeeds.getIntKey(), new ArrayList((Collection)errorConstraintSeeds.getValue()));
        }
        this.mixedStrengthGroups = new Int2ObjectOpenHashMap(builder.mixedStrengthGroups.size());
        for (Int2ObjectMap.Entry errorConstraintStrengthGroups : builder.mixedStrengthGroups.int2ObjectEntrySet()) {
            this.mixedStrengthGroups.put(errorConstraintStrengthGroups.getIntKey(), new ArrayList((Collection)errorConstraintStrengthGroups.getValue()));
        }
    }

    private static void checkTuplesListIds(Collection<TupleList> forbiddenTupleLists, Collection<TupleList> errorTupleLists) {
        IntOpenHashSet uniques = new IntOpenHashSet(forbiddenTupleLists.size() + errorTupleLists.size());
        for (TupleList tupleList : forbiddenTupleLists) {
            Preconditions.check(uniques.add(tupleList.getId()), "duplicates tupleList with id " + tupleList.getId());
        }
        for (TupleList tupleList : errorTupleLists) {
            Preconditions.check(uniques.add(tupleList.getId()), "duplicates tupleList with id " + tupleList.getId());
        }
    }

    private static void checkParameterSizes(int[] parameterSizes) {
        for (int parameterSize : parameterSizes) {
            Preconditions.check(parameterSize > 1);
        }
    }

    private static void checkExclusionTupleIdentifier(int[] parameterSizes, Collection<TupleList> forbiddenTupleLists) {
        for (TupleList forbiddenTuples : forbiddenTupleLists) {
            for (int parameter : forbiddenTuples.getInvolvedParameters()) {
                Preconditions.check(parameter >= 0);
                Preconditions.check(parameter < parameterSizes.length);
            }
        }
    }

    @Override
    public int getDefaultTestingStrength() {
        return this.getPositiveTestingStrength();
    }

    public int getPositiveTestingStrength() {
        return this.positiveTestingStrength;
    }

    public int getNegativeTestingStrength() {
        return this.negativeTestingStrength;
    }

    public List<PrimitiveStrengthGroup> getMixedStrengthGroups(int errorConstraintId) {
        return (List)this.mixedStrengthGroups.getOrDefault(errorConstraintId, List.of());
    }

    public Int2ObjectMap<List<PrimitiveStrengthGroup>> getMixedStrengthGroupsMap() {
        return this.mixedStrengthGroups;
    }

    @Override
    public List<PrimitiveStrengthGroup> getMixedStrengthGroups() {
        return this.getMixedStrengthGroups(-1);
    }

    @Override
    public int[] getParameterSizes() {
        return Arrays.copyOf(this.parameterSizes, this.parameterSizes.length);
    }

    @Override
    public double getWeight(int parameter, int value, double defaultWeight) {
        return ((Int2DoubleMap)this.weights.getOrDefault(parameter, (Object)Int2DoubleMaps.EMPTY_MAP)).getOrDefault(value, defaultWeight);
    }

    public List<PrimitiveSeed> getSeeds(int errorConstraintId) {
        return (List)this.seeds.getOrDefault(errorConstraintId, List.of());
    }

    public Int2ObjectMap<List<PrimitiveSeed>> getSeedsMap() {
        return new Int2ObjectOpenHashMap(this.seeds);
    }

    @Override
    public List<PrimitiveSeed> getSeeds() {
        return this.getSeeds(-1);
    }

    public List<TupleList> getExclusionTupleLists() {
        return Collections.unmodifiableList(this.exclusionTupleLists);
    }

    public List<TupleList> getErrorTupleLists() {
        return Collections.unmodifiableList(this.errorTupleLists);
    }

    public List<Constraint> getExclusionConstraints() {
        return Collections.unmodifiableList(this.lazyExclusionConstraints.getConstraints());
    }

    public List<Constraint> getErrorConstraints() {
        return Collections.unmodifiableList(this.lazyErrorConstraints.getConstraints());
    }

    @Override
    public ConstraintChecker getConstraintChecker() {
        return new HardConstraintCheckerFactory().createConstraintChecker(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CompleteTestModel other = (CompleteTestModel)object;
        return this.positiveTestingStrength == other.positiveTestingStrength && this.negativeTestingStrength == other.negativeTestingStrength && Arrays.equals(this.parameterSizes, other.parameterSizes) && Objects.equals(this.exclusionTupleLists, other.exclusionTupleLists) && Objects.equals(this.errorTupleLists, other.errorTupleLists) && Objects.equals(this.lazyExclusionConstraints, other.lazyExclusionConstraints) && Objects.equals(this.lazyErrorConstraints, other.lazyErrorConstraints) && Objects.equals(this.seeds, other.seeds);
    }

    public int hashCode() {
        return Objects.hash(this.positiveTestingStrength, this.negativeTestingStrength, this.parameterSizes, this.exclusionTupleLists, this.errorTupleLists, this.lazyExclusionConstraints, this.lazyErrorConstraints, this.seeds);
    }

    public String toString() {
        return "TestModel{positive testing strength=" + this.positiveTestingStrength + ", negative testing strength=" + this.negativeTestingStrength + ", parameterSizes=" + Arrays.toString(this.parameterSizes) + ", exclusionTupleLists=" + this.exclusionTupleLists + ", errorTupleLists=" + this.errorTupleLists + ", lazyExclusionConstraints=" + this.lazyExclusionConstraints + ", lazyErrorConstraints=" + this.lazyErrorConstraints + ", seeds=" + this.seeds + "}";
    }

    public static final class Builder {
        private int positiveTestingStrength = 0;
        private int negativeTestingStrength = 0;
        private int[] parameterSizes;
        private List<TupleList> exclusionTupleLists = List.of();
        private List<TupleList> errorTupleLists = List.of();
        private final Int2ObjectMap<Int2DoubleMap> weights = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<List<PrimitiveSeed>> seeds = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<List<PrimitiveStrengthGroup>> mixedStrengthGroups = new Int2ObjectOpenHashMap();

        private Builder() {
        }

        public Builder positiveTestingStrength(int positiveTestingStrength) {
            this.positiveTestingStrength = positiveTestingStrength;
            return this;
        }

        public Builder negativeTestingStrength(int negativeTestingStrength) {
            this.negativeTestingStrength = negativeTestingStrength;
            return this;
        }

        public Builder mixedStrengthGroups(Collection<PrimitiveStrengthGroup> mixedStrengthGroups) {
            this.mixedStrengthGroups(-1, mixedStrengthGroups);
            return this;
        }

        public Builder mixedStrengthGroups(int errorConstraintId, Collection<PrimitiveStrengthGroup> mixedStrengthGroups) {
            this.mixedStrengthGroups.put(errorConstraintId, new ArrayList<PrimitiveStrengthGroup>(mixedStrengthGroups));
            return this;
        }

        public Builder mixedStrengthGroups(Int2ObjectMap<? extends Collection<PrimitiveStrengthGroup>> mixedStrengthGroups) {
            for (Int2ObjectMap.Entry errorConstraintStrengthGroups : mixedStrengthGroups.int2ObjectEntrySet()) {
                this.mixedStrengthGroups(errorConstraintStrengthGroups.getIntKey(), (Collection)errorConstraintStrengthGroups.getValue());
            }
            return this;
        }

        public Builder parameterSizes(int ... parameterSizes) {
            this.parameterSizes = parameterSizes;
            return this;
        }

        public Builder exclusionTupleLists(Collection<TupleList> exclusionTupleLists) {
            this.exclusionTupleLists = new ArrayList<TupleList>(exclusionTupleLists);
            return this;
        }

        public Builder errorTupleLists(Collection<TupleList> errorTupleLists) {
            this.errorTupleLists = new ArrayList<TupleList>(errorTupleLists);
            return this;
        }

        public Builder weight(int parameter, int value, double weight) {
            ((Int2DoubleMap)this.weights.computeIfAbsent(parameter, key -> new Int2DoubleOpenHashMap())).put(value, weight);
            return this;
        }

        public Builder weights(Int2ObjectMap<Int2DoubleMap> weights) {
            for (Int2ObjectMap.Entry parameterEntry : weights.int2ObjectEntrySet()) {
                for (Int2DoubleMap.Entry valueEntry : ((Int2DoubleMap)parameterEntry.getValue()).int2DoubleEntrySet()) {
                    this.weight(parameterEntry.getIntKey(), valueEntry.getIntKey(), valueEntry.getDoubleValue());
                }
            }
            return this;
        }

        public Builder seeds(Collection<PrimitiveSeed> seeds) {
            this.seeds(-1, seeds);
            return this;
        }

        public Builder seeds(int errorConstraintId, Collection<PrimitiveSeed> seeds) {
            this.seeds.put(errorConstraintId, new ArrayList<PrimitiveSeed>(seeds));
            return this;
        }

        public Builder seeds(Int2ObjectMap<? extends Collection<PrimitiveSeed>> seeds) {
            for (Int2ObjectMap.Entry errorConstraintSeeds : seeds.int2ObjectEntrySet()) {
                this.seeds(errorConstraintSeeds.getIntKey(), (Collection)errorConstraintSeeds.getValue());
            }
            return this;
        }

        public CompleteTestModel build() {
            return new CompleteTestModel(this);
        }
    }
}

