/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.model;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.NoConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveSeed;
import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveStrengthGroup;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.List;
import java.util.Objects;

public class GroupSpecificTestModel
implements TestModel {
    private static final String DELEGATE_REQUIRED_MESSAGE = "Delegate must not be null";
    private final int errorConstraintId;
    private final int testingStrength;
    private final CompleteTestModel delegate;
    private final ConstraintChecker constraintChecker;

    private GroupSpecificTestModel(int errorConstraintId, int testingStrength, CompleteTestModel delegate, ConstraintChecker constraintChecker) {
        Preconditions.notNull(delegate, DELEGATE_REQUIRED_MESSAGE);
        Preconditions.check(errorConstraintId >= 0 || errorConstraintId == -1, "invalid group");
        Preconditions.check(testingStrength >= 0 && testingStrength <= delegate.getNumberOfParameters(), "invalid testing strength");
        this.errorConstraintId = errorConstraintId;
        this.testingStrength = testingStrength;
        this.delegate = delegate;
        this.constraintChecker = constraintChecker == null ? new NoConstraintChecker() : constraintChecker;
    }

    public static GroupSpecificTestModel positive(CompleteTestModel delegate, ConstraintChecker constraintChecker) {
        Preconditions.notNull(delegate, DELEGATE_REQUIRED_MESSAGE);
        return new GroupSpecificTestModel(-1, delegate.getPositiveTestingStrength(), delegate, constraintChecker);
    }

    public static GroupSpecificTestModel negative(int errorConstraintId, CompleteTestModel delegate, ConstraintChecker constraintChecker) {
        Preconditions.notNull(delegate, DELEGATE_REQUIRED_MESSAGE);
        return new GroupSpecificTestModel(errorConstraintId, delegate.getNegativeTestingStrength(), delegate, constraintChecker);
    }

    @Override
    public int getDefaultTestingStrength() {
        return this.testingStrength;
    }

    @Override
    public List<PrimitiveStrengthGroup> getMixedStrengthGroups() {
        return this.delegate.getMixedStrengthGroups(this.errorConstraintId);
    }

    @Override
    public int[] getParameterSizes() {
        return this.delegate.getParameterSizes();
    }

    @Override
    public double getWeight(int parameter, int value, double defaultWeight) {
        return this.delegate.getWeight(parameter, value, defaultWeight);
    }

    @Override
    public List<PrimitiveSeed> getSeeds() {
        return this.delegate.getSeeds(this.errorConstraintId);
    }

    @Override
    public ConstraintChecker getConstraintChecker() {
        return this.constraintChecker;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GroupSpecificTestModel other = (GroupSpecificTestModel)object;
        return this.errorConstraintId == other.errorConstraintId && this.testingStrength == other.testingStrength && Objects.equals(this.delegate, other.delegate) && Objects.equals(this.constraintChecker, other.constraintChecker);
    }

    public int hashCode() {
        return Objects.hash(this.errorConstraintId, this.testingStrength, this.delegate, this.constraintChecker);
    }

    public String toString() {
        if (this.errorConstraintId == -1) {
            return "GroupSpecificTestModel{positive, testingStrength=" + this.testingStrength + ", delegate=" + this.delegate + ", constraintChecker=" + this.constraintChecker + "}";
        }
        return "GroupSpecificTestModel{errorConstraintId=" + this.errorConstraintId + ", testingStrength=" + this.testingStrength + ", delegate=" + this.delegate + ", constraintChecker=" + this.constraintChecker + "}";
    }
}

