/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.model;

import de.rwth.swc.coffee4j.algorithmic.model.SeedMode;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class PrimitiveSeed {
    public static final double NO_PRIORITY = 0.0;
    private final int[] combination;
    private final SeedMode mode;
    private final double priority;

    public PrimitiveSeed(int[] combination, SeedMode mode, double priority) {
        Preconditions.notNull(combination, "combination required");
        this.combination = Arrays.copyOf(combination, combination.length);
        this.mode = mode == null ? SeedMode.NON_EXCLUSIVE : mode;
        this.priority = priority;
    }

    public int[] getCombination() {
        return Arrays.copyOf(this.combination, this.combination.length);
    }

    public SeedMode getMode() {
        return this.mode;
    }

    public double getPriority() {
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != 0.0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PrimitiveSeed other = (PrimitiveSeed)object;
        return Double.compare(other.priority, this.priority) == 0 && Arrays.equals(this.combination, other.combination) && this.mode == other.mode;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.mode, this.priority});
        result = 31 * result + Arrays.hashCode(this.combination);
        return result;
    }

    public String toString() {
        return "PrimitiveBasedSeed{combination=" + Arrays.toString(this.combination) + ", mode=" + this.mode + ", priority=" + this.priority + "}";
    }
}

