/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.model;

import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;

public class PrimitiveStrengthGroup {
    private final IntSet parameters;
    private final int strength;

    private PrimitiveStrengthGroup(IntSet parameters, int strength) {
        Preconditions.notNull(parameters);
        Preconditions.check(strength >= 0 && strength <= parameters.size(), "Strength for parameters " + parameters + " must be int range [0," + parameters.size() + "] but was " + strength);
        this.parameters = new IntOpenHashSet((IntCollection)parameters);
        this.strength = strength;
    }

    public static PrimitiveStrengthGroup ofStrength(IntSet parameters, int strength) {
        return new PrimitiveStrengthGroup(parameters, strength);
    }

    public static PrimitiveStrengthGroup ofHighestStrength(IntSet parameters) {
        return new PrimitiveStrengthGroup(parameters, parameters.size());
    }

    public IntSet getParameters() {
        return this.parameters;
    }

    public int getNumberOfParameters() {
        return this.parameters.size();
    }

    public int getStrength() {
        return this.strength;
    }

    public List<IntSet> getAllSubGroups() {
        if (this.strength == this.parameters.size()) {
            return List.of(this.parameters);
        }
        return Combinator.computeParameterCombinations(this.parameters.toIntArray(), this.strength);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PrimitiveStrengthGroup other = (PrimitiveStrengthGroup)object;
        return this.strength == other.strength && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.strength);
    }

    public String toString() {
        return "StrengthGroup{parameters=" + this.parameters + ", strength=" + this.strength + "}";
    }
}

