/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.model;

import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import java.util.Objects;
import java.util.Optional;

public final class TestResult {
    private static final TestResult SUCCESSFUL_RESULT = new TestResult(null);
    private final Throwable resultValue;

    private TestResult(Throwable resultValue) {
        this.resultValue = resultValue;
    }

    public static TestResult success() {
        return SUCCESSFUL_RESULT;
    }

    public static TestResult exceptionalSuccess(Throwable exception) {
        return new TestResult(exception);
    }

    public static TestResult failure(Throwable causeForFailure) {
        return new TestResult(causeForFailure);
    }

    public boolean isSuccessful() {
        return this.resultValue == null;
    }

    public boolean isExceptionalSuccessful() {
        return this.resultValue instanceof ErrorConstraintException;
    }

    public boolean isUnsuccessful() {
        return this.resultValue != null && !(this.resultValue instanceof ErrorConstraintException);
    }

    public Optional<Throwable> getResultValue() {
        return Optional.ofNullable(this.resultValue);
    }

    public Throwable getRequiredResultValue() {
        if (this.resultValue == null) {
            throw new NullPointerException("resultValue must not be null");
        }
        return this.resultValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TestResult other = (TestResult)object;
        return Objects.equals(this.resultValue, other.resultValue);
    }

    public int hashCode() {
        return Objects.hash(this.resultValue);
    }

    public String toString() {
        if (this.resultValue == null) {
            return "TestResult{success}";
        }
        if (this.resultValue instanceof ErrorConstraintException) {
            return "TestResult{exceptional-success}";
        }
        return "TestResult{failure, cause=" + this.resultValue + "}";
    }
}

