/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.model;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TupleList {
    private final int id;
    private final int[] involvedParameters;
    private final List<int[]> tuples;
    private final boolean markedAsCorrect;

    public TupleList(int id, int[] involvedParameters, Collection<int[]> tuples) {
        this(id, involvedParameters, tuples, false);
    }

    public TupleList(int id, int[] involvedParameters, Collection<int[]> tuples, boolean markedAsCorrect) {
        Preconditions.check(id > 0, "id must be greater than zero");
        Preconditions.notNull(involvedParameters);
        Preconditions.check(involvedParameters.length > 0, "involved parameters must not be empty");
        Preconditions.notNull(tuples);
        Preconditions.check(!tuples.isEmpty(), "list of tuples must not be empty");
        TupleList.checkTupleSize(involvedParameters, tuples);
        this.checkNoDuplicates(tuples);
        this.id = id;
        this.involvedParameters = Arrays.copyOf(involvedParameters, involvedParameters.length);
        this.tuples = new ArrayList<int[]>(tuples);
        this.markedAsCorrect = markedAsCorrect;
    }

    private void checkNoDuplicates(Collection<int[]> tuples) {
        for (int[] tuple : tuples) {
            Preconditions.check(tuples.stream().filter(currentTuple -> Arrays.equals(tuple, currentTuple)).count() == 1L, "found duplicate tuple in TupleList: " + Arrays.toString(tuple));
        }
    }

    private static void checkTupleSize(int[] identifier, Collection<int[]> forbiddenTuples) {
        for (int[] forbiddenTuple : forbiddenTuples) {
            Preconditions.check(identifier.length == forbiddenTuple.length);
        }
    }

    public int getId() {
        return this.id;
    }

    public int[] getInvolvedParameters() {
        return Arrays.copyOf(this.involvedParameters, this.involvedParameters.length);
    }

    public List<int[]> getTuples() {
        return Collections.unmodifiableList(this.tuples);
    }

    public boolean isMarkedAsCorrect() {
        return this.markedAsCorrect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleList tupleList = (TupleList)o;
        return this.id == tupleList.id && this.markedAsCorrect == tupleList.markedAsCorrect && Arrays.equals(this.involvedParameters, tupleList.involvedParameters) && Objects.equals(this.tuples, tupleList.tuples);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.tuples, this.markedAsCorrect);
        result = 31 * result + Arrays.hashCode(this.involvedParameters);
        return result;
    }

    public String toString() {
        return "TupleList{id=" + this.id + ", involvedParameters=" + Arrays.toString(this.involvedParameters) + ", tuples=" + this.tuples + ", markedAsCorrect=" + this.markedAsCorrect + "}";
    }
}

