/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.report;

import de.rwth.swc.coffee4j.algorithmic.report.ArgumentConverter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;

public class Report {
    private final String resolvableReport;
    private final Object[] arguments;
    private final BiFunction<String, Object[], String> reportResolver;
    private String resolvedReport;

    public Report(Report report) {
        this.resolvableReport = report.resolvableReport;
        this.arguments = Arrays.copyOf(report.arguments, report.arguments.length);
        this.reportResolver = report.reportResolver;
        this.resolvedReport = report.resolvedReport;
    }

    public Report(String resolvableReport, BiFunction<String, Object[], String> reportResolver, Object ... arguments) {
        this.resolvableReport = Preconditions.notNull(resolvableReport);
        this.reportResolver = Preconditions.notNull(reportResolver);
        this.arguments = Preconditions.notNull(arguments);
    }

    public static Report report(String report, Object ... arguments) {
        return new Report(report, MessageFormat::format, arguments);
    }

    public String getResolvableReport() {
        return this.resolvableReport;
    }

    public String getResolvedReport() {
        if (this.resolvedReport == null) {
            this.resolvedReport = this.reportResolver.apply(this.resolvableReport, this.arguments);
        }
        return this.resolvedReport;
    }

    public void convertArguments(ArgumentConverter argumentConverter) {
        for (int i = 0; i < this.arguments.length; ++i) {
            Object argument = this.arguments[i];
            if (!argumentConverter.canConvert(argument)) continue;
            this.arguments[i] = argumentConverter.convert(argument);
        }
    }

    public Object[] getArguments() {
        return Arrays.copyOf(this.arguments, this.arguments.length);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Report other = (Report)object;
        return Objects.equals(this.resolvableReport, other.resolvableReport) && Arrays.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.resolvableReport, this.arguments);
    }

    public String toString() {
        return "Report{resolvableReport='" + this.resolvableReport + "', replacingElements=" + Arrays.toString(this.arguments) + "}";
    }
}

