/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.report;

import de.rwth.swc.coffee4j.algorithmic.report.Report;
import de.rwth.swc.coffee4j.algorithmic.report.ReportLevel;
import java.util.function.Supplier;

public interface Reporter {
    default public void reportTrace(Report report) {
        this.report(ReportLevel.TRACE, report);
    }

    default public void reportTrace(Supplier<Report> reportSupplier) {
        this.report(ReportLevel.TRACE, reportSupplier);
    }

    default public void reportDebug(Report report) {
        this.report(ReportLevel.DEBUG, report);
    }

    default public void reportDebug(Supplier<Report> reportSupplier) {
        this.report(ReportLevel.DEBUG, reportSupplier);
    }

    default public void reportInfo(Report report) {
        this.report(ReportLevel.INFO, report);
    }

    default public void reportInfo(Supplier<Report> reportSupplier) {
        this.report(ReportLevel.INFO, reportSupplier);
    }

    default public void reportWarn(Report report) {
        this.report(ReportLevel.WARN, report);
    }

    default public void reportWarn(Supplier<Report> reportSupplier) {
        this.report(ReportLevel.WARN, reportSupplier);
    }

    default public void reportError(Report report) {
        this.report(ReportLevel.ERROR, report);
    }

    default public void reportError(Supplier<Report> reportSupplier) {
        this.report(ReportLevel.ERROR, reportSupplier);
    }

    default public void reportFatal(Report report) {
        this.report(ReportLevel.FATAL, report);
    }

    default public void reportFatal(Supplier<Report> reportSupplier) {
        this.report(ReportLevel.FATAL, reportSupplier);
    }

    public void report(ReportLevel var1, Report var2);

    public void report(ReportLevel var1, Supplier<Report> var2);

    default public void reportAssumptionViolation(String assumptionKey) {
    }

    default public void reportAssumptionSatisfaction(String assumptionKey) {
    }

    public static Reporter getEmptyReporter() {
        return new Reporter(){

            @Override
            public void report(ReportLevel level, Report report) {
            }

            @Override
            public void report(ReportLevel level, Supplier<Report> reportSupplier) {
            }
        };
    }
}

