/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.report;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Objects;

public final class ValueArgument {
    private final int parameter;
    private final int value;

    public ValueArgument(int parameter, int value) {
        Preconditions.check(parameter >= 0);
        Preconditions.check(value >= 0);
        this.parameter = parameter;
        this.value = value;
    }

    public static ValueArgument value(int parameter, int value) {
        return new ValueArgument(parameter, value);
    }

    public int getParameter() {
        return this.parameter;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ValueArgument other = (ValueArgument)object;
        return this.parameter == other.parameter && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.parameter, this.value);
    }

    public String toString() {
        return Integer.toString(this.parameter) + ":" + this.value;
    }
}

