/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.characterization;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.report.Reporter;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.algorithmic.util.PredicateUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class SuspiciousCombinationAlgorithm
implements FaultCharacterizationAlgorithm {
    protected final FaultCharacterizationConfiguration configuration;
    protected final Map<IntArrayWrapper, TestResult> testResults = new HashMap<IntArrayWrapper, TestResult>();
    protected Set<IntArrayWrapper> previousSuspiciousCombinations = new HashSet<IntArrayWrapper>();
    protected Set<IntArrayWrapper> suspiciousCombinations = new HashSet<IntArrayWrapper>();

    protected SuspiciousCombinationAlgorithm(FaultCharacterizationConfiguration configuration) {
        this.configuration = Preconditions.notNull(configuration);
    }

    protected TestModel getModel() {
        return this.configuration.getModel();
    }

    protected ConstraintChecker getChecker() {
        return this.getModel().getConstraintChecker();
    }

    protected Reporter getReporter() {
        return this.configuration.getReporter();
    }

    @Override
    public List<int[]> computeNextTestInputs(Map<int[], TestResult> nextTestResults) {
        Preconditions.notNull(nextTestResults);
        Preconditions.check(!nextTestResults.isEmpty());
        this.adjustSuspiciousSet(nextTestResults);
        this.addToTestResults(nextTestResults);
        if (this.shouldGenerateFurtherTestInputs()) {
            return this.convertNextTestInputs(nextTestResults);
        }
        return Collections.emptyList();
    }

    private void adjustSuspiciousSet(Map<int[], TestResult> nextTestResults) {
        this.previousSuspiciousCombinations = this.suspiciousCombinations;
        this.suspiciousCombinations = new HashSet<IntArrayWrapper>(this.previousSuspiciousCombinations);
        if (this.testResults.isEmpty()) {
            this.initializeSuspiciousSet(nextTestResults);
        }
        this.removeSuccessfulCombinationsFromSuspiciousSet(nextTestResults);
    }

    private void initializeSuspiciousSet(Map<int[], TestResult> nextTestResults) {
        for (Map.Entry<int[], TestResult> entry : nextTestResults.entrySet()) {
            if (!entry.getValue().isUnsuccessful()) continue;
            this.suspiciousCombinations.addAll(this.getRelevantSubCombinations(entry.getKey()));
        }
    }

    private void removeSuccessfulCombinationsFromSuspiciousSet(Map<int[], TestResult> nextTestResults) {
        for (Map.Entry<int[], TestResult> entry : nextTestResults.entrySet()) {
            if (!entry.getValue().isSuccessful()) continue;
            this.suspiciousCombinations.removeAll(this.getRelevantSubCombinations(entry.getKey()));
        }
    }

    private void addToTestResults(Map<int[], TestResult> nextTestResults) {
        for (Map.Entry<int[], TestResult> entry : nextTestResults.entrySet()) {
            this.testResults.put(IntArrayWrapper.wrap(entry.getKey()), entry.getValue());
        }
    }

    private List<int[]> convertNextTestInputs(Map<int[], TestResult> newTestResults) {
        return this.generateNextTestInputs(newTestResults).stream().filter(PredicateUtil.not(this.testResults::containsKey)).distinct().map(IntArrayWrapper::getArray).collect(Collectors.toList());
    }

    protected abstract Set<IntArrayWrapper> getRelevantSubCombinations(int[] var1);

    protected abstract boolean shouldGenerateFurtherTestInputs();

    protected abstract List<IntArrayWrapper> generateNextTestInputs(Map<int[], TestResult> var1);
}

