/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.characterization.ben;

import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.SuspiciousCombinationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.ben.SuspiciousCombinationReducer;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.algorithmic.util.PredicateUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Ben
extends SuspiciousCombinationAlgorithm {
    private static final int DEFAULT_NUMBER_OF_COMBINATIONS_PER_STEP = 10;
    private static final int DEFAULT_MAX_GENERATION_ATTEMPTS = 50;
    private final int numberOfCombinationsPerStep;
    private final int maxGenerationAttempts;
    private final Random random = new Random();
    private boolean endInNextIteration = false;

    public Ben(FaultCharacterizationConfiguration configuration) {
        this(configuration, 10, 50);
    }

    public Ben(FaultCharacterizationConfiguration configuration, int numberOfCombinationsPerStep, int maxGenerationAttempts) {
        super(configuration);
        Preconditions.check(numberOfCombinationsPerStep > 0);
        Preconditions.check(maxGenerationAttempts > 0);
        this.numberOfCombinationsPerStep = numberOfCombinationsPerStep;
        this.maxGenerationAttempts = maxGenerationAttempts;
    }

    public static FaultCharacterizationAlgorithmFactory ben() {
        return configuration -> new Ben(configuration, 10, 50);
    }

    public static FaultCharacterizationAlgorithmFactory ben(int numberOfCombinationsPerStep, int maxGenerationAttempts) {
        Preconditions.check(numberOfCombinationsPerStep > 0);
        Preconditions.check(maxGenerationAttempts > 0);
        return configuration -> new Ben(configuration, numberOfCombinationsPerStep, maxGenerationAttempts);
    }

    @Override
    public Set<IntArrayWrapper> getRelevantSubCombinations(int[] combination) {
        return Combinator.computeSubCombinations(combination, this.getModel().getDefaultTestingStrength()).stream().map(IntArrayWrapper::new).collect(Collectors.toSet());
    }

    @Override
    public boolean shouldGenerateFurtherTestInputs() {
        return this.previousSuspiciousCombinations.size() != this.suspiciousCombinations.size() && !this.endInNextIteration && this.getModel().getDefaultTestingStrength() < this.getModel().getNumberOfParameters();
    }

    @Override
    public List<IntArrayWrapper> generateNextTestInputs(Map<int[], TestResult> newTestResults) {
        Object2DoubleMap<Component> componentSuspiciousnessMap = this.computeComponentSuspiciousness(this.suspiciousCombinations);
        List<IntArrayWrapper> suspiciousCombinationsRanking = this.computeSuspiciousCombinationsRanking(componentSuspiciousnessMap, this.suspiciousCombinations);
        int numberOfNewTestInputs = Math.min(suspiciousCombinationsRanking.size(), this.numberOfCombinationsPerStep);
        ArrayList<IntArrayWrapper> newTestInputs = new ArrayList<IntArrayWrapper>(numberOfNewTestInputs);
        for (int i = 0; i < numberOfNewTestInputs; ++i) {
            int[] currentCombination = suspiciousCombinationsRanking.get(i).getArray();
            IntArrayWrapper newTestInput = this.computeNewTestInputFor(currentCombination, componentSuspiciousnessMap);
            if (newTestInput != null) {
                newTestInputs.add(newTestInput);
                continue;
            }
            this.endInNextIteration = true;
        }
        return newTestInputs;
    }

    private Object2DoubleMap<Component> computeComponentSuspiciousness(Set<IntArrayWrapper> relevantSuspiciousCombinations) {
        Component component;
        int parameter;
        Object2IntOpenHashMap numberOfFailedTestAppearances = new Object2IntOpenHashMap();
        Object2IntOpenHashMap numberOfTestAppearances = new Object2IntOpenHashMap();
        Object2IntOpenHashMap numberOfCombinationsAppearances = new Object2IntOpenHashMap();
        int numberOfSuspiciousCombinations = relevantSuspiciousCombinations.size();
        int numberOfFailedTestInputs = 0;
        for (Map.Entry entry : this.testResults.entrySet()) {
            int[] currentCombination = ((IntArrayWrapper)entry.getKey()).getArray();
            for (parameter = 0; parameter < currentCombination.length; ++parameter) {
                component = new Component(parameter, currentCombination[parameter]);
                numberOfTestAppearances.put((Object)component, numberOfTestAppearances.getOrDefault((Object)component, 0) + 1);
                if (!((TestResult)entry.getValue()).isUnsuccessful()) continue;
                numberOfFailedTestAppearances.put((Object)component, numberOfFailedTestAppearances.getOrDefault((Object)component, 0) + 1);
            }
            if (!((TestResult)entry.getValue()).isUnsuccessful()) continue;
            ++numberOfFailedTestInputs;
        }
        for (IntArrayWrapper suspiciousCombination : relevantSuspiciousCombinations) {
            int[] suspiciousCombinationArray = suspiciousCombination.getArray();
            for (parameter = 0; parameter < suspiciousCombinationArray.length; ++parameter) {
                component = new Component(parameter, suspiciousCombinationArray[parameter]);
                numberOfCombinationsAppearances.put((Object)component, numberOfCombinationsAppearances.getOrDefault((Object)component, 0) + 1);
            }
        }
        Object2DoubleOpenHashMap componentSuspiciousnessMap = new Object2DoubleOpenHashMap();
        for (int parameter2 = 0; parameter2 < this.getModel().getNumberOfParameters(); ++parameter2) {
            for (int value = 0; value < this.getModel().getParameterSize(parameter2); ++value) {
                Component component2 = new Component(parameter2, value);
                int failedTestAppearances = numberOfFailedTestAppearances.getOrDefault((Object)component2, 0);
                int testAppearances = numberOfTestAppearances.getOrDefault((Object)component2, 0);
                int combinationAppearances = numberOfCombinationsAppearances.getOrDefault((Object)component2, 0);
                double suspiciousness = (this.zeroSafeDivision(failedTestAppearances, numberOfFailedTestInputs) + (double)failedTestAppearances / (double)testAppearances + (double)combinationAppearances / (double)numberOfSuspiciousCombinations) / 3.0;
                componentSuspiciousnessMap.put((Object)component2, suspiciousness);
            }
        }
        return componentSuspiciousnessMap;
    }

    private double zeroSafeDivision(double value, double divisor) {
        return divisor == 0.0 ? 0.0 : value / divisor;
    }

    private List<IntArrayWrapper> computeSuspiciousCombinationsRanking(Object2DoubleMap<Component> componentSuspiciousnessMap, Set<IntArrayWrapper> relevantSuspiciousCombinations) {
        List<IntArrayWrapper> suspiciousnessOfCombinationRanking = this.computeSuspiciousnessOfCombinationRanking(componentSuspiciousnessMap, relevantSuspiciousCombinations);
        List<IntArrayWrapper> suspiciousnessOfEnvironmentRanking = this.computeSuspiciousnessOfEnvironmentRanking(componentSuspiciousnessMap, relevantSuspiciousCombinations);
        return relevantSuspiciousCombinations.stream().sorted(Comparator.comparingInt(combination -> suspiciousnessOfCombinationRanking.indexOf(combination) + suspiciousnessOfEnvironmentRanking.indexOf(combination))).collect(Collectors.toList());
    }

    private List<IntArrayWrapper> computeSuspiciousnessOfCombinationRanking(Object2DoubleMap<Component> componentSuspiciousnessMap, Set<IntArrayWrapper> relevantSuspiciousCombinations) {
        Object2DoubleOpenHashMap suspiciousnessOfCombinations = new Object2DoubleOpenHashMap();
        for (IntArrayWrapper combination : relevantSuspiciousCombinations) {
            int[] combinationArray = combination.getArray();
            double sum = 0.0;
            double numberOfParameters = 0.0;
            for (int parameter = 0; parameter < combinationArray.length; ++parameter) {
                if (combinationArray[parameter] == -1) continue;
                Component component = new Component(parameter, combinationArray[parameter]);
                sum += componentSuspiciousnessMap.getDouble((Object)component);
                numberOfParameters += 1.0;
            }
            suspiciousnessOfCombinations.put((Object)combination, this.zeroSafeDivision(sum, numberOfParameters));
        }
        ArrayList<IntArrayWrapper> suspiciousnessOfCombinationRanking = new ArrayList<IntArrayWrapper>(relevantSuspiciousCombinations);
        suspiciousnessOfCombinationRanking.sort(Comparator.comparing(arg_0 -> ((Object2DoubleMap)suspiciousnessOfCombinations).getDouble(arg_0)).reversed());
        return suspiciousnessOfCombinationRanking;
    }

    private List<IntArrayWrapper> computeSuspiciousnessOfEnvironmentRanking(Object2DoubleMap<Component> componentSuspiciousnessMap, Set<IntArrayWrapper> relevantSuspiciousCombinations) {
        Object2DoubleOpenHashMap suspiciousnessOfEnvironment = new Object2DoubleOpenHashMap();
        for (IntArrayWrapper combination : relevantSuspiciousCombinations) {
            double minimumAverage = this.computeMinimumAverage(combination.getArray(), componentSuspiciousnessMap);
            suspiciousnessOfEnvironment.put((Object)combination, minimumAverage);
        }
        ArrayList<IntArrayWrapper> suspiciousnessOfEnvironmentRanking = new ArrayList<IntArrayWrapper>(relevantSuspiciousCombinations);
        suspiciousnessOfEnvironmentRanking.sort(Comparator.comparing(arg_0 -> ((Object2DoubleMap)suspiciousnessOfEnvironment).getDouble(arg_0)));
        return suspiciousnessOfEnvironmentRanking;
    }

    private double computeMinimumAverage(int[] combinationArray, Object2DoubleMap<Component> componentSuspiciousnessMap) {
        double minimumAverage = Double.MAX_VALUE;
        for (IntArrayWrapper testInput : this.testResults.keySet()) {
            int[] testInputArray = testInput.getArray();
            if (!CombinationUtil.contains(testInputArray, combinationArray)) continue;
            double sum = 0.0;
            int numberOfParameters = 0;
            for (int parameter = 0; parameter < testInputArray.length; ++parameter) {
                if (combinationArray[parameter] != -1) continue;
                Component component = new Component(parameter, testInputArray[parameter]);
                sum += componentSuspiciousnessMap.getDouble((Object)component);
                ++numberOfParameters;
            }
            double average = this.zeroSafeDivision(sum, numberOfParameters);
            if (!(average < minimumAverage)) continue;
            minimumAverage = average;
        }
        return minimumAverage;
    }

    private IntArrayWrapper computeNewTestInputFor(int[] subCombination, Object2DoubleMap<Component> componentSuspiciousnessMap) {
        IntList[] parameterValueRanking = this.computeParameterValueRanking(componentSuspiciousnessMap);
        IntList environmentParameters = this.computeEnvironmentParameters(subCombination);
        int[] newTestInputArray = this.computeLowestEnvironmentSuspicionTestInput(subCombination, parameterValueRanking);
        IntArrayWrapper newTestInput = IntArrayWrapper.wrap(newTestInputArray);
        for (int i = 0; i < this.maxGenerationAttempts && this.testResults.containsKey(newTestInput) && this.getChecker().isValid(newTestInputArray); ++i) {
            int nextValue;
            int changingParameter = environmentParameters.getInt(this.random.nextInt(environmentParameters.size()));
            IntList valueRanking = parameterValueRanking[changingParameter];
            int currentValue = newTestInputArray[changingParameter];
            int nextValueIndex = (valueRanking.indexOf(currentValue) + 1) % valueRanking.size();
            newTestInputArray[changingParameter] = nextValue = valueRanking.getInt(nextValueIndex);
        }
        return this.testResults.containsKey(newTestInput) ? null : newTestInput;
    }

    private IntList[] computeParameterValueRanking(Object2DoubleMap<Component> componentSuspiciousnessMap) {
        int numberOfParameter = this.getModel().getNumberOfParameters();
        IntList[] parameterValueRanking = new IntList[numberOfParameter];
        for (int parameter = 0; parameter < numberOfParameter; ++parameter) {
            int finalParameter = parameter;
            parameterValueRanking[parameter] = new IntArrayList(IntStream.range(0, this.getModel().getParameterSize(parameter)).boxed().sorted(Comparator.comparingDouble(value -> componentSuspiciousnessMap.getDouble((Object)new Component(finalParameter, (int)value)))).mapToInt(Integer::intValue).toArray());
        }
        return parameterValueRanking;
    }

    private IntList computeEnvironmentParameters(int[] subCombination) {
        IntArrayList environmentParameters = new IntArrayList();
        for (int parameter = 0; parameter < subCombination.length; ++parameter) {
            if (subCombination[parameter] != -1) continue;
            environmentParameters.add(parameter);
        }
        return environmentParameters;
    }

    private int[] computeLowestEnvironmentSuspicionTestInput(int[] subCombination, IntList[] parameterValueRanking) {
        int[] testInput = Arrays.copyOf(subCombination, subCombination.length);
        for (int parameter = 0; parameter < subCombination.length; ++parameter) {
            if (testInput[parameter] != -1) continue;
            testInput[parameter] = parameterValueRanking[parameter].getInt(0);
        }
        return testInput;
    }

    @Override
    public List<int[]> computeFailureInducingCombinations() {
        LinkedList<Set<IntArrayWrapper>> suspiciousCombinationsByStrength = new LinkedList<Set<IntArrayWrapper>>();
        suspiciousCombinationsByStrength.add(this.suspiciousCombinations);
        for (int i = this.getModel().getDefaultTestingStrength() - 1; i > 0; --i) {
            suspiciousCombinationsByStrength.add(0, SuspiciousCombinationReducer.reduce(this.getModel().getParameterSizes(), (Collection)suspiciousCombinationsByStrength.get(0)));
        }
        return suspiciousCombinationsByStrength.stream().filter(PredicateUtil.not(Collection::isEmpty)).map(this::computeSuspiciousCombinationsRanking).flatMap(Collection::stream).map(IntArrayWrapper::getArray).collect(Collectors.toList());
    }

    private List<IntArrayWrapper> computeSuspiciousCombinationsRanking(Set<IntArrayWrapper> suspiciousCombinations) {
        return this.computeSuspiciousCombinationsRanking(this.computeComponentSuspiciousness(suspiciousCombinations), suspiciousCombinations);
    }

    private static final class Component {
        private final int parameter;
        private final int value;

        private Component(int parameter, int value) {
            this.parameter = parameter;
            this.value = value;
        }

        public int hashCode() {
            int result = this.parameter;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Component other = (Component)object;
            return this.parameter == other.parameter && this.value == other.value;
        }

        public String toString() {
            return "Component{parameter=" + this.parameter + ", value=" + this.value + "}";
        }
    }
}

