/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.characterization.ben;

import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

final class SuspiciousCombinationReducer {
    private SuspiciousCombinationReducer() {
    }

    static Set<IntArrayWrapper> reduce(int[] parameterSizes, Collection<IntArrayWrapper> suspiciousCombinations) {
        Preconditions.notNull(parameterSizes);
        Preconditions.notNull(suspiciousCombinations);
        Preconditions.check(parameterSizes.length > 0);
        int sizeOfCombinations = SuspiciousCombinationReducer.getSizeOfAllCombinations(suspiciousCombinations);
        if (suspiciousCombinations.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Bucket> buckets = SuspiciousCombinationReducer.createBuckets(parameterSizes, sizeOfCombinations - 1);
        SuspiciousCombinationReducer.fillBuckets(buckets, suspiciousCombinations);
        return SuspiciousCombinationReducer.getReducedSuspiciousCombinations(buckets, parameterSizes);
    }

    private static int getSizeOfAllCombinations(Collection<IntArrayWrapper> combinations) {
        if (!combinations.isEmpty()) {
            Iterator<IntArrayWrapper> iterator = combinations.iterator();
            int firstSize = CombinationUtil.numberOfSetParameters(iterator.next().getArray());
            while (iterator.hasNext()) {
                Preconditions.check(firstSize == CombinationUtil.numberOfSetParameters(iterator.next().getArray()));
            }
            return firstSize;
        }
        return 0;
    }

    private static Set<Bucket> createBuckets(int[] parameters, int size) {
        return Combinator.computeCombinations(parameters, size).stream().map(x$0 -> new Bucket((int[])x$0)).collect(Collectors.toSet());
    }

    private static void fillBuckets(Set<Bucket> buckets, Collection<IntArrayWrapper> suspiciousCombinations) {
        for (IntArrayWrapper suspiciousCombination : suspiciousCombinations) {
            for (Bucket bucket : buckets) {
                bucket.addIfContains(suspiciousCombination);
            }
        }
    }

    private static Set<IntArrayWrapper> getReducedSuspiciousCombinations(Set<Bucket> buckets, int[] parameterSizes) {
        HashSet<IntArrayWrapper> reducedSuspiciousCombinations = new HashSet<IntArrayWrapper>();
        for (Bucket bucket : buckets) {
            if (!bucket.containsAllPossibleContainingCombinations(parameterSizes)) continue;
            reducedSuspiciousCombinations.add(IntArrayWrapper.wrap(bucket.getCombination()));
        }
        return reducedSuspiciousCombinations;
    }

    private static class Bucket {
        private final int[] combination;
        private final Set<IntArrayWrapper> containingCombinations = new HashSet<IntArrayWrapper>();

        private Bucket(int[] combination) {
            Preconditions.notNull(combination);
            this.combination = combination;
        }

        private void addIfContains(IntArrayWrapper possibleContainingCombination) {
            Preconditions.notNull(possibleContainingCombination);
            if (CombinationUtil.contains(possibleContainingCombination.getArray(), this.combination)) {
                this.containingCombinations.add(possibleContainingCombination);
            }
        }

        private boolean containsAllPossibleContainingCombinations(int[] parameterSizes) {
            Preconditions.notNull(parameterSizes);
            Preconditions.check(parameterSizes.length >= this.combination.length);
            int numberOfPossibleContainingCombinations = 0;
            for (int parameter = 0; parameter < parameterSizes.length; ++parameter) {
                if (this.combination[parameter] != -1) continue;
                numberOfPossibleContainingCombinations += parameterSizes[parameter];
            }
            return numberOfPossibleContainingCombinations == this.containingCombinations.size();
        }

        private int[] getCombination() {
            return this.combination;
        }
    }
}

