/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.characterization.delta;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.CombinationType;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.algorithmic.util.PredicateUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ImprovedDeltaDebugging
implements FaultCharacterizationAlgorithm {
    private State state = State.INITIALIZATION;
    private final TestModel model;
    private final Object2BooleanMap<IntArrayWrapper> coveringArray = new Object2BooleanOpenHashMap();
    final Map<IntList, CombinationType> inducingCombinations = new HashMap<IntList, CombinationType>();
    private IntList currentlyProcessedTestInput = null;
    private CombinationType currentErrorType = null;
    private int[] nextExpectedTestInput = null;
    private final Map<IntList, TestResult> failingAndExceptionalPassingTestInputs = new HashMap<IntList, TestResult>();
    private IntSet relatedParameters = null;
    private IntSet unrelatedParameters = null;
    private IntSet suspiciousParameters = null;
    private IntSet subParametersOne = null;
    private IntSet subParametersTwo = null;

    public ImprovedDeltaDebugging(FaultCharacterizationConfiguration configuration) {
        Preconditions.notNull(configuration);
        this.model = configuration.getModel();
    }

    public static FaultCharacterizationAlgorithmFactory improvedDeltaDebugging() {
        return ImprovedDeltaDebugging::new;
    }

    @Override
    public List<int[]> computeNextTestInputs(Map<int[], TestResult> testResults) {
        this.assertAlgorithmInitialized();
        Preconditions.notNull(testResults);
        Preconditions.check(this.state == State.INITIALIZATION || this.containsExpectedTestInput(testResults));
        this.addToCoveringArray(testResults);
        do {
            this.computeNextTestInput();
        } while (this.nextExpectedTestInput != null && this.coveringArray.containsKey((Object)IntArrayWrapper.wrap(this.nextExpectedTestInput)));
        return this.nextExpectedTestInput == null ? Collections.emptyList() : Collections.singletonList(this.nextExpectedTestInput);
    }

    private void assertAlgorithmInitialized() {
        if (this.model == null) {
            throw new IllegalStateException("The algorithm has not been initialized");
        }
    }

    private boolean containsExpectedTestInput(Map<int[], TestResult> testResults) {
        for (int[] testInput : testResults.keySet()) {
            if (!Arrays.equals(testInput, this.nextExpectedTestInput)) continue;
            return true;
        }
        return false;
    }

    private void addToCoveringArray(Map<int[], TestResult> testResults) {
        for (Map.Entry<int[], TestResult> testResult : testResults.entrySet()) {
            this.coveringArray.put((Object)IntArrayWrapper.wrap(testResult.getKey()), testResult.getValue().isSuccessful());
        }
        testResults.entrySet().stream().filter(testResultEntry -> ((TestResult)testResultEntry.getValue()).isUnsuccessful() || ((TestResult)testResultEntry.getValue()).isExceptionalSuccessful()).forEach(testResultEntry -> this.failingAndExceptionalPassingTestInputs.put((IntList)new IntArrayList((int[])testResultEntry.getKey()), (TestResult)testResultEntry.getValue()));
    }

    private void computeNextTestInput() {
        switch (this.state) {
            case INITIALIZATION: {
                this.initializeNextFailedTestInput();
                break;
            }
            case ISOLATION: {
                this.continueIsolationWithNextTestResult();
                break;
            }
            case CHECK: {
                this.checkIfFurtherIsolationNeededWithTestResult();
                break;
            }
            default: {
                throw new IllegalStateException("No state set");
            }
        }
    }

    private void initializeNextFailedTestInput() {
        this.relatedParameters = new IntOpenHashSet();
        Optional<IntArrayList> nextFailedTestInput = this.findNextUnexplainedFailedTestInput();
        if (nextFailedTestInput.isPresent()) {
            this.currentlyProcessedTestInput = (IntList)nextFailedTestInput.get();
            Optional<Throwable> optionalThrowable = this.failingAndExceptionalPassingTestInputs.get(this.currentlyProcessedTestInput).getResultValue();
            if (!optionalThrowable.isPresent()) {
                throw new Coffee4JException("Cause of Failure must be present!");
            }
            this.currentErrorType = optionalThrowable.get() instanceof ErrorConstraintException ? CombinationType.EXCEPTION_INDUCING : CombinationType.FAILURE_INDUCING;
            this.findNextSuspiciousSchemaAndInvokeIsolation();
        } else {
            this.nextExpectedTestInput = null;
        }
    }

    private Optional<IntArrayList> findNextUnexplainedFailedTestInput() {
        return this.coveringArray.object2BooleanEntrySet().stream().filter(PredicateUtil.not(Object2BooleanMap.Entry::getBooleanValue)).map(Map.Entry::getKey).map(combination -> new IntArrayList(combination.getArray())).filter(testInput -> this.inducingCombinations.keySet().stream().noneMatch(failureInducingCombination -> CombinationUtil.contains(testInput.toIntArray(), failureInducingCombination.toIntArray()))).findFirst();
    }

    private void findNextSuspiciousSchemaAndInvokeIsolation() {
        Optional<int[]> nearestTestInput = this.findNearestPassedTestInput();
        this.suspiciousParameters = new IntOpenHashSet();
        if (nearestTestInput.isPresent()) {
            this.suspiciousParameters.addAll((IntCollection)this.calculateDifference(this.currentlyProcessedTestInput.toIntArray(), nearestTestInput.get()));
        } else {
            IntStream.range(0, this.currentlyProcessedTestInput.size()).filter(parameter -> !this.relatedParameters.contains(parameter)).forEach(arg_0 -> ((IntSet)this.suspiciousParameters).add(arg_0));
        }
        this.isolateParameter();
    }

    private Optional<int[]> findNearestPassedTestInput() {
        return this.coveringArray.object2BooleanEntrySet().stream().filter(Object2BooleanMap.Entry::getBooleanValue).map(Map.Entry::getKey).map(IntArrayWrapper::getArray).filter(testInput -> CombinationUtil.sameForAllGivenParameters(testInput, this.currentlyProcessedTestInput.toIntArray(), this.relatedParameters)).max(Comparator.comparingInt(this::similarityToFailedTestInput));
    }

    private int similarityToFailedTestInput(int[] testInput) {
        int numberOfSameParameters = 0;
        for (int parameter = 0; parameter < testInput.length; ++parameter) {
            if (testInput[parameter] != this.currentlyProcessedTestInput.getInt(parameter)) continue;
            ++numberOfSameParameters;
        }
        return numberOfSameParameters;
    }

    private IntSet calculateDifference(int[] first, int[] second) {
        IntOpenHashSet differentParameters = new IntOpenHashSet();
        for (int parameter = 0; parameter < first.length; ++parameter) {
            if (first[parameter] == second[parameter]) continue;
            differentParameters.add(parameter);
        }
        return differentParameters;
    }

    private void isolateParameter() {
        this.unrelatedParameters = new IntOpenHashSet();
        this.divideSuspiciousSchemaAndExecuteTestInput();
    }

    private void divideSuspiciousSchemaAndExecuteTestInput() {
        if (this.suspiciousParameters.size() == 1) {
            this.addIsolatedParameterToRelatedSchema();
        } else {
            this.divideSchemaIntoSubSchemas();
            this.makeIsolationTestInput();
        }
    }

    private void addIsolatedParameterToRelatedSchema() {
        this.relatedParameters.addAll((IntCollection)this.suspiciousParameters);
        this.makeTestInputForCheckWhetherFurtherIsolationIsNeeded();
    }

    private void makeTestInputForCheckWhetherFurtherIsolationIsNeeded() {
        this.nextExpectedTestInput = new int[this.currentlyProcessedTestInput.size()];
        for (int parameter = 0; parameter < this.nextExpectedTestInput.length; ++parameter) {
            int otherValueIndex;
            this.nextExpectedTestInput[parameter] = this.relatedParameters.contains(parameter) ? this.currentlyProcessedTestInput.getInt(parameter) : (otherValueIndex = (this.currentlyProcessedTestInput.getInt(parameter) + 1) % this.model.getParameterSize(parameter));
        }
        this.state = State.CHECK;
    }

    private void divideSchemaIntoSubSchemas() {
        int firstSubSchemaSize = this.suspiciousParameters.size() / 2;
        this.subParametersOne = new IntOpenHashSet(firstSubSchemaSize);
        this.subParametersTwo = new IntOpenHashSet(this.suspiciousParameters.size() - firstSubSchemaSize);
        int currentIndex = 0;
        IntIterator intIterator = this.suspiciousParameters.iterator();
        while (intIterator.hasNext()) {
            int parameter = (Integer)intIterator.next();
            if (currentIndex < firstSubSchemaSize) {
                this.subParametersOne.add(parameter);
            } else {
                this.subParametersTwo.add(parameter);
            }
            ++currentIndex;
        }
    }

    private void makeIsolationTestInput() {
        this.nextExpectedTestInput = new int[this.currentlyProcessedTestInput.size()];
        for (int parameter = 0; parameter < this.nextExpectedTestInput.length; ++parameter) {
            int otherValueIndex;
            this.nextExpectedTestInput[parameter] = this.unrelatedParameters.contains(parameter) || this.subParametersOne.contains(parameter) ? (otherValueIndex = (this.currentlyProcessedTestInput.getInt(parameter) + 1) % this.model.getParameterSize(parameter)) : this.currentlyProcessedTestInput.getInt(parameter);
        }
        this.state = State.ISOLATION;
    }

    private void continueIsolationWithNextTestResult() {
        if (this.coveringArray.getBoolean((Object)IntArrayWrapper.wrap(this.nextExpectedTestInput))) {
            this.suspiciousParameters = this.subParametersOne;
        } else {
            this.suspiciousParameters = this.subParametersTwo;
            this.unrelatedParameters.addAll((IntCollection)this.subParametersOne);
        }
        this.divideSuspiciousSchemaAndExecuteTestInput();
    }

    private void checkIfFurtherIsolationNeededWithTestResult() {
        if (this.coveringArray.getBoolean((Object)IntArrayWrapper.wrap(this.nextExpectedTestInput))) {
            this.findNextSuspiciousSchemaAndInvokeIsolation();
        } else {
            this.inducingCombinations.put((IntList)new IntArrayList(this.constructFailureInducingCombination()), this.currentErrorType);
            this.initializeNextFailedTestInput();
        }
    }

    private int[] constructFailureInducingCombination() {
        int[] failureInducingCombination = new int[this.currentlyProcessedTestInput.size()];
        for (int parameter = 0; parameter < failureInducingCombination.length; ++parameter) {
            failureInducingCombination[parameter] = this.relatedParameters.contains(parameter) ? this.currentlyProcessedTestInput.getInt(parameter) : -1;
        }
        return failureInducingCombination;
    }

    @Override
    public List<int[]> computeFailureInducingCombinations() {
        return this.inducingCombinations.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList());
    }

    private static enum State {
        INITIALIZATION,
        ISOLATION,
        CHECK;

    }
}

