/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.characterization.mixtgte;

import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.CombinationType;
import de.rwth.swc.coffee4j.algorithmic.interleaving.util.OptimalValue;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Mixtgte
implements FaultCharacterizationAlgorithm {
    private final TestModel testModel;
    private final ConstraintChecker checker;
    private int currentStrength = 1;
    private final int expectedStrength;
    private final Set<int[]> passingTestInputs = new HashSet<int[]>();
    private final Map<IntList, CombinationType> failingAndExceptionalPassingTestInputs = new HashMap<IntList, CombinationType>();
    private Set<int[]> tupleSet = null;
    private final List<int[]> unknownTuples = new ArrayList<int[]>();
    private final Set<int[]> passingTuples = new HashSet<int[]>();
    private final Map<IntList, CombinationType> failingAndExceptionalPassingTuples = new HashMap<IntList, CombinationType>();
    final Map<IntList, CombinationType> isolatedMinInducingCombinations = new HashMap<IntList, CombinationType>();
    private final List<Set<BitSet>> bitmasks;
    private final IntList parameterSizes;
    private final IntList parameters;
    private final int numberOfParameters;
    private final Set<IntList> executedInputs = new HashSet<IntList>();
    private static final long MAX_NUMBER_OF_ITERATIONS = 30000L;

    public Mixtgte(TestModel testModel) {
        Preconditions.notNull(testModel);
        this.testModel = testModel;
        this.expectedStrength = testModel.getDefaultTestingStrength();
        this.checker = testModel.getConstraintChecker();
        this.bitmasks = new ArrayList<Set<BitSet>>(testModel.getDefaultTestingStrength());
        this.parameterSizes = new IntArrayList(testModel.getParameterSizes());
        this.numberOfParameters = testModel.getNumberOfParameters();
        this.parameters = new IntArrayList(this.numberOfParameters);
        IntStream.range(0, this.numberOfParameters).forEach(arg_0 -> ((IntList)this.parameters).add(arg_0));
        this.computeBitmasks();
    }

    private void computeBitmasks() {
        HashSet<BitSet> leaves = new HashSet<BitSet>(this.numberOfParameters);
        for (int index = 0; index < this.numberOfParameters; ++index) {
            BitSet leaf = new BitSet(this.numberOfParameters);
            leaf.set(index);
            leaves.add(leaf);
        }
        this.bitmasks.add(leaves);
        for (int currentSize = 0; currentSize < this.testModel.getDefaultTestingStrength() - 1; ++currentSize) {
            HashSet<BitSet> nextSet = new HashSet<BitSet>();
            for (BitSet mask : this.bitmasks.get(currentSize)) {
                for (int index = mask.length(); index < this.numberOfParameters; ++index) {
                    BitSet parent = (BitSet)mask.clone();
                    parent.set(index);
                    nextSet.add(parent);
                }
            }
            this.bitmasks.add(nextSet);
        }
    }

    public Mixtgte(FaultCharacterizationConfiguration config) {
        this(config.getModel());
    }

    public static FaultCharacterizationAlgorithmFactory mixtgte() {
        return Mixtgte::new;
    }

    @Override
    public List<int[]> computeNextTestInputs(Map<int[], TestResult> testResults) {
        int[] nextExpectedTestInput = null;
        Optional testResult = testResults.entrySet().stream().findFirst();
        Map.Entry testRes = null;
        if (testResult.isPresent()) {
            testRes = (Map.Entry)testResult.get();
            int[] testInput = (int[])testRes.getKey();
            TestResult result = (TestResult)testRes.getValue();
            this.executedInputs.add((IntList)new IntArrayList(testInput));
            if (result.isSuccessful()) {
                this.passingTestInputs.add(testInput);
            } else {
                Optional<Throwable> optCause = result.getResultValue();
                optCause.ifPresent(throwable -> this.failingAndExceptionalPassingTestInputs.put((IntList)new IntArrayList(testInput), throwable instanceof ErrorConstraintException ? CombinationType.EXCEPTION_INDUCING : CombinationType.FAILURE_INDUCING));
            }
        }
        while (nextExpectedTestInput == null) {
            if (this.currentStrength <= this.expectedStrength) {
                if (this.tupleSet == null) {
                    this.computeAndClassifyTuplesOfGivenSize();
                }
                if (testResult.isPresent()) {
                    this.updateTupleSets((int[])testRes.getKey(), (TestResult)testRes.getValue());
                    this.updateMinInducingCombinations();
                }
                if (!this.unknownTuples.isEmpty() || !this.failingAndExceptionalPassingTuples.isEmpty() && !this.inducingTuplesExplained()) {
                    nextExpectedTestInput = this.buildTest();
                    if (nextExpectedTestInput != null) continue;
                    ++this.currentStrength;
                    this.tupleSet = null;
                    continue;
                }
                ++this.currentStrength;
                this.tupleSet = null;
                continue;
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(nextExpectedTestInput);
    }

    private void computeAndClassifyTuplesOfGivenSize() {
        this.tupleSet = this.generateTupleSetOfGivenSize(this.testModel.getParameterSizes(), this.currentStrength);
        block0: for (int[] tuple2 : this.tupleSet) {
            boolean isPassing = false;
            for (int[] nArray : this.passingTestInputs) {
                if (!CombinationUtil.contains(nArray, tuple2)) continue;
                this.passingTuples.add(tuple2);
                isPassing = true;
                break;
            }
            if (isPassing) continue;
            for (Map.Entry entry : this.failingAndExceptionalPassingTestInputs.entrySet()) {
                if (!CombinationUtil.contains(((IntList)entry.getKey()).toIntArray(), tuple2)) continue;
                this.failingAndExceptionalPassingTuples.put((IntList)new IntArrayList(tuple2), (CombinationType)((Object)entry.getValue()));
                continue block0;
            }
        }
        this.passingTuples.forEach(tuple -> this.failingAndExceptionalPassingTuples.remove(new IntArrayList(tuple)));
        this.unknownTuples.addAll(this.tupleSet);
        this.unknownTuples.removeAll(this.passingTuples);
        this.unknownTuples.removeAll(this.failingAndExceptionalPassingTuples.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList()));
    }

    @Override
    public List<int[]> computeFailureInducingCombinations() {
        return this.isolatedMinInducingCombinations.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList());
    }

    private Set<int[]> generateTupleSetOfGivenSize(int[] parameters, int size) {
        Set<int[]> subCombinations = Combinator.computeCombinations(parameters, size);
        subCombinations.removeAll(subCombinations.stream().filter(combination -> !this.checker.isValid((int[])combination)).collect(Collectors.toList()));
        return subCombinations;
    }

    private int[] buildTest() {
        int[] newTest = null;
        if (!this.unknownTuples.isEmpty()) {
            Collections.shuffle(this.unknownTuples);
            newTest = CombinationUtil.emptyCombination(this.testModel.getNumberOfParameters());
            for (int[] tuple : this.unknownTuples) {
                if (!CombinationUtil.canBeAdded(newTest, tuple, this.checker)) continue;
                CombinationUtil.add(newTest, tuple);
                if (!CombinationUtil.containsAllParameters(newTest, newTest.length - 1)) continue;
                return newTest;
            }
            newTest = this.generateTestInputForTuple(newTest);
        } else {
            ArrayList<IntList> failingCombinations = new ArrayList<IntList>(this.failingAndExceptionalPassingTuples.keySet());
            failingCombinations.removeAll(failingCombinations.stream().filter(combination -> this.isExplained(combination.toIntArray())).collect(Collectors.toList()));
            Collections.shuffle(failingCombinations);
            ArrayList<IntList> toRemove = new ArrayList<IntList>();
            for (IntList tuple : failingCombinations) {
                newTest = this.generateTestInputForTuple(tuple.toIntArray());
                if (newTest != null) {
                    toRemove.forEach(this.failingAndExceptionalPassingTuples::remove);
                    return newTest;
                }
                toRemove.add(tuple);
            }
        }
        return newTest;
    }

    private int[] generateTestInputForTuple(int[] newTest) {
        int[] nextTestInput = null;
        long tries = 0L;
        long iterations = 1L;
        for (int i = 0; i < newTest.length; ++i) {
            if (newTest[i] != -1) continue;
            iterations *= (long)this.parameterSizes.getInt(i);
        }
        iterations = Long.min(iterations, 30000L);
        block1: while (nextTestInput == null && tries < iterations) {
            ++tries;
            nextTestInput = Arrays.copyOf(newTest, this.numberOfParameters);
            Collections.shuffle(this.parameters);
            IntListIterator intListIterator = this.parameters.iterator();
            while (intListIterator.hasNext()) {
                int parameter = (Integer)intListIterator.next();
                if (nextTestInput[parameter] != -1) continue;
                Optional<ParameterValuePair> optimalValue = OptimalValue.valueForParameter(parameter, this.testModel.getParameterSize(parameter), nextTestInput, this.executedInputs, this.checker);
                if (optimalValue.isPresent()) {
                    nextTestInput[parameter] = optimalValue.get().getValue();
                    continue;
                }
                this.executedInputs.add((IntList)new IntArrayList(nextTestInput));
                nextTestInput = null;
                continue block1;
            }
        }
        return nextTestInput;
    }

    private void updateTupleSets(int[] testCase, TestResult result) {
        HashSet<int[]> toMove = new HashSet<int[]>();
        for (int[] tuple2 : this.unknownTuples) {
            if (!CombinationUtil.contains(testCase, tuple2)) continue;
            toMove.add(tuple2);
        }
        if (result.isUnsuccessful() || result.isExceptionalSuccessful()) {
            this.unknownTuples.removeAll(toMove);
            toMove.forEach(tuple -> this.failingAndExceptionalPassingTuples.put((IntList)new IntArrayList(tuple), result.getResultValue().orElse(null) instanceof ErrorConstraintException ? CombinationType.EXCEPTION_INDUCING : CombinationType.FAILURE_INDUCING));
        } else {
            this.unknownTuples.removeAll(toMove);
            this.passingTuples.addAll(toMove);
            toMove = new HashSet();
            for (int[] tuple2 : this.failingAndExceptionalPassingTuples.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList())) {
                if (!CombinationUtil.contains(testCase, tuple2)) continue;
                toMove.add(tuple2);
            }
            toMove.forEach(fic -> this.failingAndExceptionalPassingTuples.remove(new IntArrayList(fic)));
            this.passingTuples.addAll(toMove);
            toMove = new HashSet();
            for (int[] tuple2 : this.isolatedMinInducingCombinations.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList())) {
                if (!CombinationUtil.contains(testCase, tuple2)) continue;
                toMove.add(tuple2);
            }
            toMove.forEach(combination -> this.isolatedMinInducingCombinations.remove(new IntArrayList(combination)));
            this.passingTuples.addAll(toMove);
        }
    }

    private void updateMinInducingCombinations() {
        HashSet<int[]> toMove = new HashSet<int[]>();
        for (int[] tuple : this.failingAndExceptionalPassingTuples.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList())) {
            if (!this.isIsoMinInducing(tuple)) continue;
            toMove.add(tuple);
        }
        if (!toMove.isEmpty()) {
            toMove.forEach(fic -> this.isolatedMinInducingCombinations.put((IntList)new IntArrayList(fic), this.failingAndExceptionalPassingTuples.get(new IntArrayList(fic))));
            toMove.forEach(fic -> this.failingAndExceptionalPassingTuples.remove(new IntArrayList(fic)));
        }
    }

    private boolean isInducing(int[] tuple) {
        if (CombinationUtil.numberOfSetParameters(tuple) == 0) {
            return false;
        }
        for (int[] input : this.passingTestInputs) {
            if (!CombinationUtil.contains(input, tuple)) continue;
            this.failingAndExceptionalPassingTuples.remove(new IntArrayList(tuple));
            this.isolatedMinInducingCombinations.remove(new IntArrayList(tuple));
            return false;
        }
        return true;
    }

    private boolean isMinInducing(int[] tuple) {
        if (!this.isInducing(tuple)) {
            return false;
        }
        HashSet subMasks = new HashSet();
        for (int i = 0; i < CombinationUtil.numberOfSetParameters(tuple) - 1; ++i) {
            subMasks.addAll(this.bitmasks.get(i));
        }
        for (BitSet subMask : subMasks) {
            if (!this.isInducing(this.getSubCombination(tuple, subMask))) continue;
            return false;
        }
        return true;
    }

    private boolean isIsoMinInducing(int[] tuple) {
        if (!this.isMinInducing(tuple)) {
            return false;
        }
        for (int[] testInput : this.failingAndExceptionalPassingTestInputs.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList())) {
            if (!CombinationUtil.contains(testInput, tuple) || !this.isIsoMinInducing(tuple, testInput)) continue;
            this.failingAndExceptionalPassingTuples.put((IntList)new IntArrayList(tuple), this.failingAndExceptionalPassingTestInputs.get(new IntArrayList(testInput)));
            return true;
        }
        return false;
    }

    private boolean isIsoMinInducing(int[] tuple, int[] testCase) {
        HashSet subMasks = new HashSet();
        for (int i = 0; i < CombinationUtil.numberOfSetParameters(tuple); ++i) {
            subMasks.addAll(this.bitmasks.get(i));
        }
        for (BitSet subMask : subMasks) {
            int[] subCombination = this.getSubCombination(testCase, subMask);
            if (!this.isMinInducing(subCombination) || Arrays.equals(subCombination, tuple)) continue;
            return false;
        }
        return true;
    }

    private int[] getSubCombination(int[] tuple, BitSet submask) {
        int[] combination = new int[tuple.length];
        for (int index = 0; index < tuple.length; ++index) {
            combination[index] = submask.get(index) ? tuple[index] : -1;
        }
        return combination;
    }

    private boolean isExplained(int[] tuple) {
        for (int[] mfic : this.isolatedMinInducingCombinations.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList())) {
            if (!CombinationUtil.contains(tuple, mfic)) continue;
            return true;
        }
        return false;
    }

    private boolean inducingTuplesExplained() {
        for (int[] tuple : this.failingAndExceptionalPassingTuples.keySet().stream().map(IntCollection::toIntArray).collect(Collectors.toList())) {
            if (this.isExplained(tuple)) continue;
            return false;
        }
        return true;
    }
}

